/*
 * C compiler
 * ==========
 *
 * Copyright 1989, 1990, 1991 Christoph van Wuellen.
 * Credits to Matthew Brandt.
 * All commercial rights reserved.
 *
 * This compiler may be redistributed as long there is no
 * commercial interest. The compiler must not be redistributed
 * without its full sources. This notice must stay intact.
 *
 * History:
 *
 * 1989   starting an 68000 C compiler, starting with material
 *        originally by M. Brandt
 * 1990   68000 C compiler further bug fixes
 *        started i386 port (December)
 * 1991   i386 port finished (January)
 *        further corrections in the front end and in the 68000
 *        code generator.
 *        The next port will be a SPARC port
 */

#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

#ifdef INTEL_386

/* variable initialization */

enum e_gt {
    nogen, bytegen, wordgen, longgen, floatgen
};
enum e_sg {
    noseg, codeseg, dataseg
};


char           *outlate();
#define outlate(X) (X)
unsigned long   genffp();

enum e_gt       gentype;
enum e_sg       curseg;
int             outcol;

static char *regname[NUMREG+1];

struct oplst {
    char           *s;
    enum e_op       ov;
}               opl[] =

{
"mov", op_mov,
"movsbl", op_movsbl,
"movzbl", op_movzbl,
"movswl", op_movswl,
"movzwl", op_movzwl,
"movzbw", op_movzbw,
"movsbw", op_movsbw,
"cltd",   op_cltd,
"push",   op_push,
"pop",    op_pop,
"add",    op_add,
"sub",    op_sub,
"inc",    op_inc,
"dec",    op_dec,
"imul",   op_imul,
"idiv",   op_idiv,
"and",    op_and,
"neg",    op_neg,
"not",    op_not,
"or",     op_or,
"xor",    op_xor,
"clr",    op_clr,
"shl",    op_shl,
"shr",    op_shr,
"sar",    op_asr,
"cmp",    op_cmp,
"lea",    op_lea,
"jmp",    op_bra,
"jmp",    op_jmp,
"call",   op_call,
"je",     op_je,
"jne",    op_jne,
"jle",    op_jle,
"jge",    op_jge,
"jl",     op_jl,
"jg",     op_jg,
"jbe",    op_jbe,
"jae",    op_jae,
"jb",     op_jb,
"ja",     op_ja,
"leave",  op_leave,
"ret",    op_ret,
"rep",    op_rep,
"smov",   op_smov,
"test",   op_test,
"fadd",   op_fadd,
"fsub",   op_fsub,
"fmul",   op_fmul,
"fdiv",   op_fdiv,
"fchs",   op_fchs,
"fld",    op_fld,
"fst",    op_fst,
"fstp",   op_fstp,
"fstp %st(0)", op_fpop,
"fcompp", op_fcompp,
"fnstsw", op_fnstsw,
"sahf",   op_sahf,
0, 0
};

out_init()
{
    int i;

    fprintf(output,"\t.file\t\"C386GENERATED\"\n");
    fprintf(output,"\t.version\t\"C386 V 1.0\"\n");
    fprintf(output,"\t.optim\n");
    fputs("c386_compiled.:\n", output);
    curseg = noseg;
    gentype = nogen;
    outcol = 0;
    for (i=0; i<=NUMREG; i++)
        regname[i]="%INVALID_REGISTER";
    regname[EAX]="%eax";
    regname[EBX]="%ebx";
    regname[ECX]="%ecx";
    regname[EDX]="%edx";
    regname[EDI]="%edi";
    regname[ESI]="%esi";
    regname[EBP]="%ebp";
    regname[ESP]="%esp";
    regname[AX] ="%ax";
    regname[BX] ="%bx";
    regname[CX] ="%cx";
    regname[DX] ="%dx";
    regname[DI] = "%di";
    regname[SI] = "%si";
    regname[AL] ="%al";
    regname[BL] ="%bl";
    regname[CL] ="%cl";
    regname[DL] ="%dl";
}

putop(op)
    enum e_op       op;
{
    int             i;
    i = 0;
    while (opl[i].s) {
	if (opl[i].ov == op) {
	    fputs(opl[i].s, output);
	    return;
	}
	++i;
    }
    fatal("illegal opcode");
}

putconst(offset)
/*
 * put a constant to the output file.
 */
    struct enode   *offset;
{

    if (offset == 0) {
        putc('0',output);
        return;
    }
    switch (offset->nodetype) {
      case en_autocon:
      case en_icon:
	fprintf(output, "%ld", offset->v.i);
	break;
      case en_labcon:
	fprintf(output, ".L%ld", offset->v.i);
	break;
      case en_nacon:
	fputs(outlate(offset->v.sp), output);
	break;
      case en_add:
	putconst(offset->v.p[0]);
	putc('+', output);
	putconst(offset->v.p[1]);
	break;
      case en_sub:
	putconst(offset->v.p[0]);
	putc('-', output);
	putconst(offset->v.p[1]);
	break;
      case en_uminus:
	putc('-', output);
	putconst(offset->v.p[0]);
	break;
      default:
	fatal("illegal constant node");
	break;
    }
}

putlen(l)
/*
 * append the length field to an instruction.
 */
    int             l;
{
    if (l == 0)
	return;
    switch (l) {
      case 1:
	putc('b', output);
	break;
      case 2:
	putc('w', output);
	break;
      case 4:
	putc('l', output);
	break;
      case 5:
        /* special value for single precision float */
        putc('s', output);
        break;
      case 9:
        /* special value for double precision float */
        putc('l', output);
        break;
      default:
	fatal("illegal length field");
	break;
    }
}

putamode(ap,len)
/*
 * output a general addressing mode.
 */
    struct amode   *ap;
{
    int reg;
    switch (ap->mode) {
      case am_immed:
	putc('$', output);
      case am_direct:
	putconst(ap->offset);
	break;
      case am_star:
        putc('*',output);
      case am_reg:
        reg=ap->preg;
        if (len == 1) reg=REG8(reg);
        if (len == 2) reg=REG16(reg);
        fputs (regname[reg], output);
	break;
      case am_indx:
	if (ap->offset != 0)
            putconst(ap->offset);
        fprintf(output,"(%s)",regname[ap->preg]);
	break;
      case am_indx2:
	if (ap->offset != 0)
            putconst(ap->offset);
        fprintf(output,"(%s,%s)",regname[ap->preg],regname[ap->sreg]);
        break;
      default:
	fatal("illegal address mode");
	break;
    }
}

put_code(op, len, aps, apd)
/*
 * output a generic instruction.
 */
    struct amode   *aps, *apd;
    int             len;
    enum e_op       op;
{
    int len1=len, len2=len;
/*
 * this is expensive, but some assemblers require it
 * this is to be moved to the peephole optimizer
 */
    switch(op) {
      case op_movsbw:
      case op_movzbw:
        len2=2;
      case op_movsbl:
      case op_movzbl:
        len1=1;
        break;
      case op_movswl:
      case op_movzwl:
        len1=2;
        break;
    }

    putop(op);
    putlen(len);
/*
 * Sun reverses the INTEL syntax:
 * The source comes first
 * The destination comes second
 * The imul instruction is special (3 operands), this
 * is handled here
 */
    if (aps != 0) {
	putc(' ', output);
	putamode(aps,len1);
	if (apd != 0) {
	    putc(',', output);
	    putamode(apd,len2);
/*
 * Assembler has strange syntax
 */
            if (op == op_imul && aps->mode == am_immed && apd->mode == am_reg) {
                putc(',',output);
                putamode(apd,len2);
            }
	}
    }
    putc('\n', output);
}


g_strlab(s)
/*
 * generate a named label.
 */
    char           *s;
{
    fputs(outlate(s), output);
    putc(':', output);
    putc('\n', output);
}

put_label(lab)
/*
 * output a compiler generated label.
 */
    unsigned int    lab;
{
    fprintf(output, ".L%u:\n", lab);
}

genbyte(val)
    int             val;
{
    if (gentype == bytegen && outcol < 60) {
	fprintf(output, ",%d", val & 0x00ff);
	outcol += 4;
    } else {
	nl();
	fprintf(output, "\t.byte %d", val & 0x00ff);
	gentype = bytegen;
	outcol = 19;
    }
}

genword(val)
    int             val;
{
    /* stupid assembler has no .word */
    /* emit low byte, high byte */
    genbyte(val & 255);
    genbyte((val >> 8) & 255);
}

genfloat(val)
    double          val;
{
    fprintf(output,"\t.float %20.15e\n",val);
}

gendouble(val)
    double          val;
{
    fprintf(output,"\t.double %20.15e\n",val);
}

genlong(val)
    long            val;
{
    if (gentype == longgen && outcol < 56) {
	fprintf(output, ",%ld", val);
	outcol += 10;
    } else {
	nl();
	fprintf(output, "\t.long %ld", val);
	gentype = longgen;
	outcol = 25;
    }
}

genptr(node)
    struct enode   *node;
{
    if (gentype == longgen && outcol < 46) {
	putc(',', output);
	putconst(node);
	outcol += 10;
    } else {
	nl();
	fputs("\t.long ", output);
	putconst(node);
	gentype = longgen;
	outcol = 25;
    }
}


static int      align_counter = 0;
genstorage(sp, align)
    struct sym     *sp;
    int             align;
{
    nl();
    if (sp->storage_class == sc_static) {
        if (lc_bss % align != 0) {
	    fprintf(output, ".lcomm .LA%d,%ld\n", align_counter++,
		    (long) align - (lc_bss % align));
	    lc_bss += (align - lc_bss % align);
        }
	fprintf(output, ".lcomm .L%ld,%ld\n", sp->value.i, sp->tp->size);
        lc_bss += sp->tp->size;
     } else
	fprintf(output, ".comm %s,%ld\n", outlate(sp->name),sp->tp->size);
}


int
stringlit(s, len)
/*
 * mk_ s a string literal and return it's label number.
 */
    char           *s;
    int             len;	/* without \0 */
{
    struct slit    *lp;
    char           *p;
    int             local_global = global_flag;
    global_flag = 0;		/* always allocate from local space. */
    lp = (struct slit *) xalloc((int) sizeof(struct slit));
    lp->label = nextlabel++;
    p = lp->str = (char *) xalloc(len);
    lp->len = len;
    while (len--)
	*p++ = *s++;
    lp->next = strtab;
    strtab = lp;
    global_flag = local_global;
    return lp->label;
}

dumplits()
/*
 * dump the string literal pool.
 */
{
    char           *cp;
    int             len;
    while (strtab != 0) {
	cseg();
	nl();
	put_label((unsigned int) strtab->label);
	cp = strtab->str;
	len = strtab->len;
	while (len--)
	    genbyte(*cp++);
	genbyte(0);
	strtab = strtab->next;
    }
    nl();
}


put_external(s)
    char           *s;
/* put the definition of an external name in the ouput file */
{
    fputs(".globl ", output);
    fputs(outlate(s), output);
    putc('\n', output);
}


put_global(s)
    char           *s;
/* put the definition of a global name in the output file */
{
    put_external(s);
}

put_align(align)
    int             align;
/* align the following data */
{
    if (align == 1) return;
    fprintf(output,"\t.align %d\n",align);
}

nl()
{
    if (outcol > 0) {
	putc('\n', output);
	outcol = 0;
	gentype = nogen;
    }
}

cseg()
{
    if (curseg != codeseg) {
	nl();
	fputs("\t.text\n", output);
	curseg = codeseg;
    }
}

dseg()
{
    if (curseg != dataseg) {
	nl();
	fputs("\t.data\n", output);
	curseg = dataseg;
    }
}
#endif /* INTEL_386 */
