#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

extern char	act_file[];
extern int	act_line;

/*
 * The inline expansion of strcmp() in search (and in searchkw) reduced
 * the overall execution time by an amount over 25 percent since the
 * compiler very frequently searching something in the symbol tables...
 */

SYM	       *
search(na, ttail)

/*
 * If your machine is low on registers, delete the register attribute in the
 * next two lines since it is more important to keep s1 and s2 in registers
 */

register SYM		*ttail;
register char		*na;

{
    register char  *s1;
    register char  *s2;
    while (ttail != 0) {
	s1 = ttail->name;
	s2 = na;
	for (;;) {
	    if (*s1++ != *s2)
		break;
	    if (*s2++ == '\0')
		return ttail;
	}
	ttail = ttail->prev;
    }
    return 0;
}

SYM	       *
gsearch(na)
    char	   *na;
{
    SYM 	   *sp;
    if ((sp = search(na, lsyms.tail)) == 0)
	sp = search(na, gsyms.tail);
    return sp;
}

void
append(ptr_sp, table)
    SYM 	   **ptr_sp;
    TABLE	   *table;
{
    SYM		   *sp1,*sp=*ptr_sp;

    if (table == &gsyms && (sp1=search(sp->name, table->tail)) != 0) {
	/*
	 * The global symbol table has only one level, this means
	 * that we only check if the new declaration is compatible
	 * with the old one
	 */

	if (!eq_type(sp->tp,sp1->tp))
	    error(ERR_REDECL);
	/*
	 * The new storage class depends on the old and on the new
	 * one.
	 */
	/*
	 * if both are the same, there is nothing to do.
	 * two times global is illegal
	 */
	if (sp->storage_class == sp1->storage_class) {
	    *ptr_sp=sp1; /* caller uses old entry */
	    return;
	}
	/*
	 * since we use compiler generated label for static data,
	 * we must retain sc_static
	 */
	if (sp1->storage_class == sc_static) {
	    *ptr_sp=sp1; /* caller uses old entry */
	    return;
	}
	/*
	 * if the new storage class is global, we must update sp1
	 * to generate the .globl directive at the very end
	 * and perhaps the size (e.g. for arrays)
	 */
	if (sp->storage_class == sc_global) {
	    sp1->storage_class = sc_global;
	    *ptr_sp=sp1; /* caller uses old entry */
	    return;
	}
	/*
	 * if the new storage class is static, set it to
	 * global (since we may have used the ,real' name and
	 * cannot use compiler generated names for this symbol from
	 * now on) and set sp->value.i to -1 to prevent it from
	 * being exported via .globl directives
	 */
	if (sp->storage_class == sc_static) {
	    sp1->storage_class = sc_global;
	    sp1->value.i = -1;
	    *ptr_sp=sp1; /* caller uses old entry */
	    return;
	}
	/*
	 * last case: global declaration followed by external decl.:
	 * just do nothing
	 */
	*ptr_sp=sp1; /* caller uses old entry */
	return;
    }
    if (table->head == 0) {
	/* The table is empty so far... */
	table->head = table->tail = sp;
	sp->next = sp->prev = 0;
	sp->used = 0;
    } else {
	table->tail->next = sp;
	sp->prev = table->tail;
	table->tail = sp;
	sp->next = 0;
	sp->used = 0;
    }
}
