#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

/*
 * this module handles the allocation and de-allocation of temporary
 * registers. when a temporary register is allocated the stack depth is saved
 * in the field deep of the address mode structure. when validate is called
 * on an address mode structure the stack is popped until the register is
 * restored to it's pre-push value.
 */

struct amode	push[] = {{am_adec, 7}},
		pop[] = {{am_ainc, 7}};
int		next_data, next_addr;
int		max_data, max_addr;

g_push(reg, rmode)
/*
 * this routine generates code to push a register onto the stack
 */
    int 	    reg;
enum e_am rmode;
{
    struct amode   *ap1;
    ap1 = (struct amode *) xalloc((int) sizeof(struct amode));
    ap1->preg = reg;
    ap1->mode = rmode;
    g_code(op_move, 4l, ap1, push);
}

g_pop(reg, rmode)
/*
 * generate code to pop the primary register in ap from the stack.
 */
    int 	    reg;
enum e_am rmode;
{
    struct amode   *ap1;
    ap1 = (struct amode *) xalloc((int) sizeof(struct amode));
    ap1->preg = reg;
    ap1->mode = rmode;
    g_code(op_move, 4l, pop, ap1);
}

initstack()
/*
 * this routine should be called before each expression is evaluated to mk_
 * sure the stack is balanced and all of the registers are marked free.
 */
{
    next_data = 0;
    next_addr = 0;
    max_data = MAX_DATA;
    max_addr = MAX_ADDR;
}

validate(ap)
/*
 * validate will mk_ sure that if a register within an address mode has been
 * pushed onto the stack that it is popped back at this time.
 */
    struct amode   *ap;
{
    switch (ap->mode) {
    case am_direct:
    case am_immed:
	return;			/* no registers used */
    case am_dreg:
	if (ap->preg > MAX_DATA)
	    return;		/* not a temporary */
	if (max_data - ap->deep >= (MAX_DATA + 1)) {
	    g_pop(ap->preg, am_dreg);
	    --max_data;
	}
	break;
    case am_indx2:
	if (ap->sreg > MAX_DATA)
	    return;		/* not a temporary */
	if (max_data - ap->deep >= (MAX_DATA + 1)) {
	    g_pop(ap->sreg, am_dreg);
	    --max_data;
	}
	break;
    case am_indx3:
	if (ap->sreg > MAX_ADDR)
	    return;		/* not a temporary */
	if (max_addr - ap->deep >= (MAX_ADDR + 1)) {
	    g_pop(ap->sreg, am_areg);
	    --max_addr;
	}
    default:
	if (ap->preg > MAX_ADDR)
	    return;		/* not a temp register */
	if (max_addr - ap->deep >= (MAX_ADDR + 1)) {
	    g_pop(ap->preg, am_areg);
	    --max_addr;
	}
	break;
    }
}

struct amode   *
temp_data()
/*
 * allocate a temporary data register and return it's addressing mode.
 */
{
    struct amode   *ap;
    ap = (struct amode *) xalloc((int) sizeof(struct amode));
    ap->mode = am_dreg;
    ap->preg = next_data % (MAX_DATA + 1);
    ap->deep = next_data;
    if (next_data > max_data) {
	g_push(next_data % (MAX_DATA + 1), am_dreg);
	max_data = next_data;
    }
    ++next_data;
    return ap;
}

free_data()
/*
 * returns TRUE if a data register is available at ,,no cost'' (no push).
 * Used to determine e.g. wether cmp.w #0,An or move.l An,Dm is better
 */
{
    return (next_data <= max_data);
}

struct amode   *
temp_addr()
/*
 * allocate a temporary address register and return it's addressing mode.
 */
{
    struct amode   *ap;
    ap = (struct amode *) xalloc((int) sizeof(struct amode));
    ap->mode = am_areg;
    ap->preg = next_addr % (MAX_ADDR + 1);
    ap->deep = next_addr;
    if (next_addr > max_addr) {
	g_push(next_addr % (MAX_ADDR + 1), am_areg);
	max_addr = next_addr;
    }
    ++next_addr;
    return ap;
}

freeop(ap)
/*
 * release any temporary registers used in an addressing mode.
 */
    struct amode   *ap;
{
    if (ap->mode == am_immed || ap->mode == am_direct)
	return;			/* no registers used */
    if ((ap->mode == am_dreg && ap->preg < (MAX_DATA + 1)) ||
	(ap->mode == am_indx2 && ap->sreg < (MAX_DATA + 1))
	)
	--next_data;
    else if (ap->mode == am_indx3 && ap->sreg < (MAX_ADDR + 1))
	--next_addr;
    else if (ap->preg < (MAX_ADDR + 1))
	--next_addr;
}

temp_inv()
/*
 * push any used temporary registers. necessary if a function is to be called
 *
 * d0..dn and a0..am are temp's n is MAX_DATA m is MAX_ADDR
 */
{
    struct amode   *result;
    int 	    i;

    /* data registers */
    for (i = 0; i <= MAX_DATA; i++)
	result = temp_data();
    for (i = 0; i <= MAX_DATA; i++)
	freeop(result);

    /* address registers */
    for (i = 0; i <= MAX_ADDR; i++)
	result = temp_addr();
    for (i = 0; i <= MAX_ADDR; i++)
	freeop(result);
}
