#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

struct ocode   *peep_head = 0, *peep_tail = 0;

struct amode   *
copy_addr(ap)
/*
 * copy an address mode structure (these things dont last).
 */
    struct amode   *ap;
{
    struct amode   *newap;
    if (ap == 0)
	return 0;
    newap = (struct amode *) xalloc((int) sizeof(struct amode));
    newap->mode = ap->mode;
    newap->preg = ap->preg;
    newap->sreg = ap->sreg;
    newap->tempflag = ap->tempflag;
    newap->deep = ap->deep;
    newap->offset = ap->offset;
    return newap;
}

g_code(op, len, ap1, ap2)
/*
 * generate a code sequence into the peep list.
 */
    long	    len;
 enum e_op op;
    struct amode   *ap1, *ap2;
{
    struct ocode   *new;
    new = (struct ocode *) xalloc((int) sizeof(struct ocode));
    new->opcode = op;
    new->length = len;
    new->oper1 = copy_addr(ap1);
    new->oper2 = copy_addr(ap2);
    add_peep(new);
}

add_peep(new)
/*
 * add the ocoderuction pointed to by new to the peep list.
 */
    struct ocode   *new;
{
    if (peep_head == 0) {
	peep_head = peep_tail = new;
	new->fwd = 0;
	new->back = 0;
    } else {
	new->fwd = 0;
	new->back = peep_tail;
	peep_tail->fwd = new;
	peep_tail = new;
    }
}

g_label(labno)
/*
 * add a compiler generated label to the peep list.
 */
    int 	    labno;
{
    struct ocode   *new;
    new = (struct ocode *) xalloc((int) sizeof(struct ocode));
    new->opcode = op_label;
    new->oper1 = mk_immed((long)labno);
    add_peep(new);
}

flush_peep()
/*
 * output all code and labels in the peep list.
 */
{
    opt3();			/* do the peephole optimizations */
    while (peep_head != 0) {
	if (peep_head->opcode == op_label)
	    put_label((int)peep_head->oper1->offset->v.i);
	else
	    put_ocode(peep_head);
	peep_head = peep_head->fwd;
    }
}

put_ocode(p)
/*
 * output the instruction passed.
 */
    struct ocode   *p;
{
    put_code(p->opcode, p->length, p->oper1, p->oper2);
}

peep_pea(ip)
/*
 * changes lea <ea>,An + pea (An) to pea <ea> The value of An is not needed
 * CAVEAT code generator modifier!
 */
    struct ocode   *ip;
{
    struct ocode   *prev;
    if (ip->oper1->mode != am_ind)
	return;
    if ((prev = ip->back) == 0)
	return;
    if (prev->opcode == op_lea && prev->oper2->preg == ip->oper1->preg) {
	prev->opcode = op_pea;
	prev->oper2 = 0;
	prev->fwd = ip->fwd;
    }
}

peep_move(ip)
/*
 * peephole optimization for move instructions.
 * makes quick immediates when possible (redundant for most assemblers).
 * changes move #0 to clr except on address registers
 * changes move #0 to address registers to sub An,An
 * changes long moves to address registers to short when possible.
 * changes move immediate to stack to pea.
 * changes move immediate to An	to lea.
 * deletes move <ea>,<ea> (The code generator does not know that this sets
 *			   the flags, and it is necessary for peep_and
 *			   to work correctly)
 */
    struct ocode   *ip;
{
    struct enode   *ep;
    struct ocode   *prev;

    if (equal_address(ip->oper1,ip->oper2)) {
	if ((prev=ip->back) == 0)
	    fprintf(stderr,"DIAG: peep_move: prev == NULL\n");
	else {
	    prev->fwd=ip->fwd;
	    if (prev->fwd != 0)
		prev->fwd->back = prev;
	}
    }

    if (ip->oper1->mode != am_immed)
	return;

    ep = ip->oper1->offset;
    if (ip->oper2->mode == am_areg && ep->nodetype == en_icon) {
	if (ep->v.i == 0) {
	    ip->length = 4;
	    ip->opcode = op_sub;
	    ip->oper1 = ip->oper2;
	} else if (-32768 <= ep->v.i && ep->v.i <= 32767)
	    ip->length = 2;
	return;
    }

    if (ip->oper2->mode == am_dreg && ep->nodetype == en_icon
	&& -128 <= ep->v.i && ep->v.i <= 127) {
	ip->opcode = op_moveq;
	ip->length = 0;
	return;
    }

    if (ep->nodetype == en_icon && ep->v.i == 0) {
	ip->opcode = op_clr;
	ip->oper1 = ip->oper2;
	ip->oper2 = 0;
	return;
    }
    if (ip->oper2->mode == am_adec && ip->oper2->preg == 7
	&& ip->length == 4) {
	ip->opcode = op_pea;
	ip->length = 0;
	ip->oper1->mode = am_direct;
	ip->oper2 = 0;
	return;
    }
    if (ip->oper2->mode == am_areg && ip->length == 4) {
	ip->opcode = op_lea;
	ip->length = 0;
	ip->oper1->mode = am_direct;
	return;
    }
}

int
equal_address(ap1, ap2)
/*
 * compare two address nodes and return true if they are equivalent.
 */
    struct amode   *ap1, *ap2;
{
    if (ap1 == 0 || ap2 == 0)
	return 0;
    if (ap1->mode != ap2->mode)
	return 0;
    switch (ap1->mode) {
    case am_areg:
    case am_dreg:
    case am_ind:
	return ap1->preg == ap2->preg;
    case am_indx:
	return ap1->preg == ap2->preg &&
	    ap1->offset == ap2->offset;
    case am_indx2:
    case am_indx3:
	return
	    ap1->preg == ap2->preg &&
	    ap1->sreg == ap2->sreg &&
	    ap1->offset == ap2->offset;
    }
    return 0;
}

peep_add(ip)
/*
 * peephole optimization for add instructions.
 * makes quick immediates out of small constants (redundant for most as's).
 */
    struct ocode   *ip;
{
    struct enode   *ep;
    if (ip->oper1->mode != am_immed)
	return;
    ep = ip->oper1->offset;
    if (ip->oper2->mode != am_areg)
	ip->opcode = op_addi;
    if (ep->nodetype != en_icon)
	return;
    if (1 <= ep->v.i && ep->v.i <= 8) {
	ip->opcode = op_addq;
	return;
	}
    if (-8 <= ep->v.i && ep->v.i <= -1) {
	ip->opcode = op_subq;
	ep->v.i = -ep->v.i;
	return;
    }
    if (ip->oper2->mode == am_areg && isshort(ep)) {
	ip->length=2;
	return;
	}
}

peep_and(ip)
/*
 * conversion of unsigned data types often yields statements like
 * move.b source,d0 +  andi.l #255,d0
 * which should be converted to
 * clr.l d0 + move.b source,d0
 */
    struct ocode   *ip;
{
    struct ocode   *prev;
    int 	    size;
    long	    arg;
    if (ip->oper1->mode != am_immed ||
	ip->oper1->offset->nodetype != en_icon)
	return;
    arg = ip->oper1->offset->v.i;
    if (ip->oper1->mode != am_immed ||
	(arg != 255 && arg != 65535))
	return;

    size = (arg == 255) ? 1 : 2;

    if ((prev = ip->back) == 0 || prev->length != size
	|| prev->opcode != op_move
	|| ip->oper2->mode != am_dreg || prev->oper2->mode != am_dreg
	|| ip->oper2->preg != prev->oper2->preg)
	return;

    prev->length = ip->length;
    ip->length = size;
    prev->opcode = op_clr;
    ip->opcode = op_move;
    ip->oper1 = prev->oper1;
    prev->oper1 = prev->oper2;
    prev->oper2 = 0;

    peep_clr(prev);
}

int
peep_clr(ip)
/*
 * removes consecutive clr-statements
 *
 */
    struct ocode   *ip;
{
    struct ocode   *prev;

    if ((prev = ip->back) == 0 || prev->opcode != op_clr ||
	!equal_address(ip->oper1, prev->oper1))
	return;

    if (prev->length < ip->length)
	prev->length = ip->length;

    if ((prev->fwd = ip->fwd) != 0)
	prev->fwd->back = prev;
}

peep_sub(ip)
/*
 * peephole optimization for subtract instructions.
 * makes quick immediates out of small constants (redundant for most as's).
 */
    struct ocode   *ip;
{
    struct enode   *ep;
    if (ip->oper1->mode != am_immed)
	return;
    ep = ip->oper1->offset;
    if (ip->oper2->mode != am_areg)
	ip->opcode = op_subi;
    else {
	if (isshort(ep))
	    ip->length = 2;
    }
    if (ep->nodetype != en_icon)
	return;
    if (1 <= ep->v.i && ep->v.i <= 8)
	ip->opcode = op_subq;
    else if (-8 <= ep->v.i && ep->v.i <= -1) {
	ip->opcode = op_addq;
	ep->v.i = -ep->v.i;
    }
}

int
peep_cmp(ip)
/*
 * peephole optimization for compare instructions.
 * changes compare #0 to tst
 *
 */
    struct ocode   *ip;
{
    struct enode   *ep;
    if (ip->oper1->mode != am_immed)
	return;
    ep = ip->oper1->offset;
    if (ip->oper2->mode == am_areg)
	/* cmpa.w extents the first argument automatically */
    {
	if (isshort(ep))
	    ip->length = 2;
	return;
    }
    ip->opcode = op_cmpi;
    if (ep->nodetype != en_icon || ep->v.i != 0)
	return;
    ip->oper1 = ip->oper2;
    ip->oper2 = 0;
    ip->opcode = op_tst;
    peep_tst(ip);
}

int
peep_tst(ip)
/*
 * deletes a tst instruction if the flags are already set.
 */
    struct ocode   *ip;
{
    struct ocode   *prev;
    prev = ip->back;
    if (prev == 0)
	return;
    if ((((prev->opcode == op_move || prev->opcode == op_moveq
	   || prev->opcode == op_clr)
	  && equal_address(prev->oper1, ip->oper1))
	 && prev->oper2->mode != am_areg) ||
	(prev->opcode != op_label &&
	 equal_address(prev->oper2, ip->oper1))) {
	prev->fwd = ip->fwd;
	if (prev->fwd != 0)
	    prev->fwd->back = prev;
    }
}


peep_uctran(ip)
/*
 * peephole optimization for unconditional transfers. deletes instructions
 * which have no path. applies to bra, jmp, and rts instructions.
 */
    struct ocode   *ip;
{
    while (ip->fwd != 0 && ip->fwd->opcode != op_label) {
	ip->fwd = ip->fwd->fwd;
	if (ip->fwd != 0)
	    ip->fwd->back = ip;
    }
}

opt3()
/*
 * peephole optimizer. This routine calls the instruction specific
 * optimization routines above for each instruction in the peep list.
 */
{
    struct ocode   *ip;
    ip = peep_head;
    while (ip != 0) {
	switch (ip->opcode) {
	case op_move:
	    peep_move(ip);
	    break;
	case op_pea:
	    peep_pea(ip);
	    break;
	case op_add:
	    peep_add(ip);
	    break;
	case op_and:
	    peep_and(ip);
	    break;
	case op_clr:
	    peep_clr(ip);
	    break;
	case op_sub:
	    peep_sub(ip);
	    break;
	case op_cmp:
	    peep_cmp(ip);
	    break;
	case op_tst:
	    peep_tst(ip);
	    break;
	case op_bra:
	case op_jmp:
	case op_rts:
	    peep_uctran(ip);
	}
	ip = ip->fwd;
    }
}
