#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

/* variable initialization	 */

enum e_gt {
    nogen, bytegen, wordgen, longgen, floatgen
};
enum e_sg {
    noseg, codeseg, dataseg
};


char	       *outlate();
unsigned long	genffp();

enum e_gt	gentype;
enum e_sg	curseg;
int		outcol;

struct oplst {
    char	   *s;
    enum e_op	    ov;
}		opl[] =
{{
	"move", op_move
}, {
    "moveq", op_moveq
}, {
    "add", op_add
},
{
    "add", op_addi
}, {
    "addq", op_addq
}, {
    "sub", op_sub
},
{
    "sub", op_subi
}, {
    "subq", op_subq
}, {
    "and", op_and
},
{
    "or", op_or
}, {
    "eor", op_eor
}, {
    "muls", op_muls
},
{
    "divs", op_divs
}, {
    "swap", op_swap
}, {
    "beq", op_beq
},
{
    "bhi", op_bhi
}, {
    "bcc", op_bhs
}, {
    "bcs", op_blo
},
{
    "bls", op_bls
}, {
    "mulu", op_mulu
}, {
    "divu", op_divu
},
{
    "bne", op_bne
}, {
    "blt", op_blt
}, {
    "ble", op_ble
},
{
    "bgt", op_bgt
}, {
    "bge", op_bge
}, {
    "neg", op_neg
},
{
    "not", op_not
}, {
    "cmp", op_cmp
}, {
    "ext", op_ext
},
{
    "jmp", op_jmp
}, {
    "jsr", op_jsr
}, {
    "rts", op_rts
},
{
    "lea", op_lea
}, {
    "asr", op_asr
}, {
    "asl", op_asl
},
{
    "clr", op_clr
}, {
    "link", op_link
}, {
    "unlk", op_unlk
},
{
    "bra", op_bra
}, {
    "movem", op_movem
}, {
    "pea", op_pea
},
{
    "cmp", op_cmpi
}, {
    "tst", op_tst
}, {
    "dbra", op_dbra
},
{
    0, 0
}
};

out_init()
{
    fprintf(output,"#NO_APP\n");
    fprintf(output,"c68_compiled.:\n");
    curseg = noseg;
    gentype = nogen;
    outcol = 0;
}

putop(op)
    enum e_op	    op;
{
    int 	    i;
    i = 0;
    while (opl[i].s) {
	if (opl[i].ov == op) {
	    fprintf(output, "\t%s", opl[i].s);
	    return;
	}
	++i;
    }
    fprintf(stderr,"DIAG - illegal opcode.\n");
}

putconst(offset)
/*
 * put a constant to the output file.
 */
    struct enode   *offset;
{

    switch (offset->nodetype) {
    case en_autocon:
    case en_icon:
	fprintf(output, "%ld", offset->v.i);
	break;
    case en_fcon:
	fprintf(output, "0x%lx", genffp(offset->v.f));
	break;
    case en_labcon:
	fprintf(output, "L%ld", offset->v.i);
	break;
    case en_nacon:
	fprintf(output, "%s", outlate(offset->v.sp));
	break;
    case en_add:
	putconst(offset->v.p[0]);
	fprintf(output, "+");
	putconst(offset->v.p[1]);
	break;
    case en_sub:
	putconst(offset->v.p[0]);
	fprintf(output, "-");
	putconst(offset->v.p[1]);
	break;
    case en_uminus:
	fprintf(output, "-");
	putconst(offset->v.p[0]);
	break;
    default:
	fprintf(stderr,"DIAG - illegal constant node.\n");
	break;
    }
}

putlen(l)
/*
 * append the length field to an instruction.
 */
    int 	    l;
{
    switch (l) {
    case 0:
	break;			/* no length field */
    case 1:
	fprintf(output, "b");
	break;
    case 2:
	fprintf(output, "w");
	break;
    case 4:
	fprintf(output, "l");
	break;
    default:
	fprintf(output, "X");
	fprintf(stderr,"DIAG - illegal length field.\n");
	break;
    }
}

putamode(ap)
/*
 * output a general addressing mode.
 */
    struct amode   *ap;
{
    switch (ap->mode) {
    case am_immed:
	fprintf(output, "#");
    case am_direct:
	putconst(ap->offset);
	break;
    case am_areg:
	fprintf(output, "a%d", ap->preg);
	break;
    case am_dreg:
	fprintf(output, "d%d", ap->preg);
	break;
    case am_ind:
	fprintf(output, "a%d@", ap->preg);
	break;
    case am_ainc:
	fprintf(output, "a%d@+", ap->preg);
	break;
    case am_adec:
	fprintf(output, "a%d@-", ap->preg);
	break;
    case am_indx:
	fprintf(output, "a%d@(", ap->preg);
	putconst(ap->offset);
	fprintf(output, ")");
	break;
    case am_indx2:
	fprintf(output, "a%d@(", ap->preg);
	putconst(ap->offset);
	fprintf(output, ",d%d:l)", ap->sreg);
	break;
    case am_indx3:
	fprintf(output, "a%d@(", ap->preg);
	putconst(ap->offset);
	fprintf(output, ",a%d:l)", ap->sreg);
	break;
    case am_mask1:
    case am_mask2:
	fprintf(output, "#0x%04x", (int)ap->offset->v.i);
	break;
    default:
	fprintf(stderr,"DIAG - illegal address mode.\n");
	break;
    }
}

put_code(op, len, aps, apd)
/*
 * output a generic instruction.
 */
    struct amode   *aps, *apd;
    int 	    len;
enum e_op op;
{
    putop(op);
    putlen(len);
    if (aps != 0) {
	fprintf(output, " ");
	putamode(aps);
	if (apd != 0) {
	    fprintf(output, ",");
	    putamode(apd);
	}
    }
    fprintf(output, "\n");
}


g_strlab(s)
/*
 * generate a named label.
 */
    char	   *s;
{
    fprintf(output, "%s:\n", outlate(s));
}

put_label(lab)
/*
 * output a compiler generated label.
 */
    int 	    lab;
{
    fprintf(output, "L%d:\n", lab);
}

genbyte(val)
    int 	    val;
{
    if (gentype == bytegen && outcol < 60) {
	fprintf(output, ",%d", val & 0x00ff);
	outcol += 4;
    } else {
	nl();
	fprintf(output, "\t.byte %d", val & 0x00ff);
	gentype = bytegen;
	outcol = 19;
    }
}

genword(val)
    int 	    val;
{
    val &= 0xffff;
    if (gentype == wordgen && outcol < 58) {
	fprintf(output, ",%d", val);
	outcol += 6;
    } else {
	nl();
	fprintf(output, "\t.even\n");
	fprintf(output, "\t.word %d", val);
	gentype = wordgen;
	outcol = 21;
    }
}

genfloat(val)
    double	    val;
{
    if (gentype == floatgen && outcol < 56) {
	fprintf(output, ",0x%ld", genffp(val));
	outcol += 10;
    } else {
	nl();
	fprintf(output, "\t.even\n");
	fprintf(output, "\t.long 0x%lx", genffp(val));
	gentype = floatgen;
	outcol = 25;
    }
}

genlong(val)
    long	    val;
{
    if (gentype == longgen && outcol < 56) {
	fprintf(output, ",%ld", val);
	outcol += 10;
    } else {
	nl();
	fprintf(output, "\t.even\n");
	fprintf(output, "\t.long %ld", val);
	gentype = longgen;
	outcol = 25;
    }
}

genptr(node)
struct enode *node;
{
    if (gentype == longgen && outcol < 46) {
	fprintf(output, ",");
	putconst(node);
	outcol += 10;
    } else {
	nl();
	fprintf(output, "\t.even\n");
	fprintf(output, "\t.long ");
	putconst(node);
	gentype = longgen;
	outcol = 25;
    }
}


static int	align_counter = 0;
genstorage(sp, align)
    SYM 	   *sp;
    int 	    align;
{
    nl();
    if (lc_bss % align != 0) {
	fprintf(output, ".lcomm LA%d,%ld\n", align_counter++,
		(long)align - (lc_bss % align));
	lc_bss += (align - lc_bss % align);
    }
    if (sp->storage_class != sc_static)
	fprintf(output, ".lcomm %s,%ld\n", outlate(sp->name)
		,sp->tp->size);
    else
	fprintf(output, ".lcomm L%ld,%ld\n", sp->value.i, sp->tp->size);
    lc_bss += sp->tp->size;
}

g_labref(n)
    int 	    n;
{
    if (gentype == longgen && outcol < 58) {
	fprintf(output, ",L%d", n);
	outcol += 6;
    } else {
	nl();
	fprintf(output, "\t.even\n");
	fprintf(output, "\t.long L%d", n);
	outcol = 22;
	gentype = longgen;
    }
}

int
stringlit(s)
/*
 * mk_ s a string literal and return it's label number.
 */
    char	   *s;
{
    struct slit    *lp;
    int 	    local_global = global_flag;
    global_flag = 0;		/* always allocate from local space. */
    lp = (struct slit *) xalloc((int) sizeof(struct slit));
    lp->label = nextlabel++;
    lp->str = strsave(s);
    lp->next = strtab;
    strtab = lp;
    global_flag = local_global;
    return lp->label;
}

dumplits()
/*
 * dump the string literal pool.
 */
{
    char	   *cp;
    while (strtab != 0) {
	cseg();
	nl();
	put_label(strtab->label);
	cp = strtab->str;
	while (*cp)
	    genbyte(*cp++);
	genbyte(0);
	strtab = strtab->next;
    }
    nl();
}


put_external(s)
    char	   *s;
/* put the definition of an external name in the ouput file */
{
    fprintf(output, ".globl %s\n", outlate(s));
}

put_global(s)
    char	   *s;
/* put the definition of a global name in the output file */
{
    fprintf(output, ".globl %s\n", outlate(s));
}

put_align(align)
    int 	    align;
/* align the following data */
{
    switch (align) {
    case 1:
	break;
    default:
	fprintf(output, "\n\t.even\n");
    }
}

nl()
{
    if (outcol > 0) {
	fprintf(output, "\n");
	outcol = 0;
	gentype = nogen;
    }
}

cseg()
{
    if (curseg != codeseg) {
	nl();
	fprintf(output, "\t.text\n");
	curseg = codeseg;
    }
}

dseg()
{
    if (curseg != dataseg) {
	nl();
	fprintf(output, "\t.data\n");
	curseg = dataseg;
    }
}

char	       *
outlate(s)
    char	   *s;
{
    static char     symbol[80];
    if (*s == '$') {
	strcpy(symbol, ++s);
    } else {
	symbol[0] = '_';
	strcpy(symbol + 1, s);
    }
    return symbol;
}
