#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

/*
 * Memory is allocated in Blocks of 2048 bytes, which form a linked list
 */

struct blk {
    struct blk	   *next;
    char	    m[2048];	   /* memory area */
};

#define NIL_BLK ( (struct blk *) 0)

static int	glbsize = 0,	/* size left in current global block */
		locsize = 0,	/* size left in current local block */
		glbindx = 0,	/* global index */
		locindx = 0;	/* local index */

static int	max_mem = 0,	/* statistics... */
		glo_mem = 0;

static struct blk *locblk = NIL_BLK,	/* pointer to local block list */
		  *glbblk = NIL_BLK;	/* pointer to global block list */

int	       *
xalloc(siz)
    int 	    siz;
{
    struct blk	   *bp;
    char	   *rv;
    char	   *calloc();
    /* align on 32-bit boundaries... necessary for the SparcStation */
    if (siz & 3)
	siz += 4 - (siz & 3);

    if (global_flag) {
	if (glbsize >= siz) {
	    rv = &(glbblk->m[glbindx]);
	    glbsize -= siz;
	    glbindx += siz;
	    return (int *) rv;
	} else {
	    bp = (struct blk *) calloc(1, (int) sizeof(struct blk));
	    if (bp == NULL) {
		fprintf(stderr," not enough memory.\n");
		exit(1);
	    }
	    glo_mem++;
	    bp->next = glbblk;
	    glbblk = bp;
	    glbsize = 2048 - siz;
	    glbindx = siz;
	    return (int *) glbblk->m;
	}
    } else { /* not global */
	if (locsize >= siz) {
	    rv = &(locblk->m[locindx]);
	    locsize -= siz;
	    locindx += siz;
	    return (int *) rv;
	} else {
	    bp = (struct blk *) calloc(1, (int) sizeof(struct blk));
	    if (bp == NULL) {
		fprintf(stderr," not enough local memory.\n");
		exit(1);
	    }
	    bp->next = locblk;
	    locblk = bp;
	    locsize = 2048 - siz;
	    locindx = siz;
	    return (int *) locblk->m;
	}
    }
}

rel_local()
{
    struct blk	   *bp1, *bp2;
    int 	    blkcnt;
    blkcnt = 0;
    bp1 = locblk;
    while (bp1 != 0) {
	bp2 = bp1->next;
	free( (char *)bp1);
	++blkcnt;
	bp1 = bp2;
    }
    if (blkcnt + glo_mem >max_mem) max_mem=blkcnt+glo_mem;
    locblk = 0;
    locsize = 0;
    lsyms.head = lsyms.tail = 0;
    ltags.head = ltags.tail = 0;
    labsyms.head = labsyms.tail = 0;
    if (list_option)
	fprintf(stderr," releasing %2d Kbytes  local tables.\n", blkcnt * 2);
}

rel_global()
{
    struct blk	   *bp1, *bp2;
    int 	    blkcnt;
    bp1 = glbblk;
    blkcnt = 0;
    while (bp1 != 0) {
	bp2 = bp1->next;
	free( (char *)bp1);
	++blkcnt;
	bp1 = bp2;
    }
    if (blkcnt > max_mem) max_mem = blkcnt;
    glo_mem=0;
    glbblk = 0;
    glbsize = 0;
    gsyms.head = gsyms.tail = 0;/* clear global symbol table */
    gtags.head = gtags.tail = 0;
    if (list_option)
	fprintf(stderr," releasing %2d Kbytes global tables.\n", blkcnt * 2);
    strtab = 0; 		/* clear literal table */
    nextlabel = 0;
    lc_bss = 0;
    fprintf(stderr,"Maximum memory request was %d KBytes.\n",max_mem*2);
    max_mem=0;
}

