#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"
/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

long inittype(),initstruct(),initarray();

doinit(sp, align)
    SYM 	   *sp;
    int 	    align;
{
    nl();
    if (lastst != assign)
	genstorage(sp, align);
    else {
	dseg();			/* select data segment */
	put_align(align);
	if (sp->storage_class == sc_static)
	    put_label((int)sp->value.i);
	else
	    g_strlab(sp->name);
	getsym();
	inittype(sp->tp);
    }
}

long
inittype(tp)
    TYP 	   *tp;
{
    int		    brace_seen = 0;
    long	    nbytes;
    if (lastst == begin) {
	brace_seen = 1;
	getsym();
    }

    switch (tp->type) {
    case bt_char:
    case bt_uchar:
	nbytes = initchar();
	break;
    case bt_short:
    case bt_ushort:
    case bt_enum:
	nbytes = initshort();
	break;
    case bt_pointer:
	if (tp->val_flag)
	    nbytes = initarray(tp);
	else {
	    nbytes = initpointer();
	}
	break;
    case bt_ulong:
    case bt_long:
	nbytes = initlong();
	break;
    case bt_float:
	nbytes = initfloat();
	break;
    case bt_struct:
	nbytes = initstruct(tp);
	break;
    default:
	error(ERR_NOINIT);
	nbytes = 0;
    }
    if (brace_seen) needpunc(end);
    return nbytes;
}

long
initarray(tp)
    TYP 	   *tp;
{
    long	    nbytes;
    char	   *p;
    nbytes = 0;
    if (lastst==sconst && (tp->btp->type==bt_char ||
	tp->btp->type==bt_uchar)) {
	nbytes=strlen(laststr)+1;
	p=laststr;
	while (*p) genbyte(*p++);
	genbyte(0);
	while (nbytes<tp->size) {
	    genbyte(0);
	    nbytes++;
	}
	getsym(); /* skip sconst */
    } else
	for(;;) {
	    nbytes += inittype(tp->btp);
	    if (lastst==comma) getsym();
	    if (lastst == end) {
		while (nbytes<tp->size) {
		    genbyte(0);
		    nbytes++;
		}
		break;
	    }
	    if (tp->size > 0  && nbytes >= tp->size) break;
	}
    if (tp->size == 0) tp->size = nbytes;
    if (nbytes>tp->size) error(ERR_INITSIZE);
    return nbytes;
}

long
initstruct(tp)
    TYP 	   *tp;
{
    SYM 	   *sp;
    long	    nbytes;
    nbytes = 0;
    sp = tp->lst.head;		/* start at top of symbol table */
    while (sp != 0) {
	while (nbytes < sp->value.i) {	/* align properly */
	    nbytes++;
	    genbyte(0);
	    }
	nbytes += inittype(sp->tp);
	if (lastst == comma) getsym();
	if (lastst == end) break;
	sp = sp->next;
    }
    while (nbytes < tp->size) {
	genbyte(0);
	nbytes++;
    }
    return tp->size;
}

initchar()
{
    genbyte( (int) intexpr());
    return 1;
}

initshort()
{
    genword((int)intexpr());
    return 2;
}

initlong()
{
    genlong(intexpr());
    return 4;
}

initfloat()
{
    double	    floatexpr();
    genfloat(floatexpr());
    return 4;
}

initpointer()
{
struct enode *ep;
TYP *tp;
tp = exprnc(&ep);
if (tp == 0)
    error(ERR_SYNTAX);
else {
    opt4(&ep);
    if (tst_const(ep))
	genptr(ep);
    else
	error(ERR_ILLINIT);
}
return 4;
}
