#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

int		breaklab;
int		contlab;
int		retlab;

extern TYP	stdfunc;
extern struct amode push[], pop[];

struct amode   *
mk_dreg(r)
/*
 * mk_ an address reference to a data register.
 */
    int 	    r;
{
    struct amode   *ap;
    ap = (struct amode *) xalloc((int) sizeof(struct amode));
    ap->mode = am_dreg;
    ap->preg = r;
    return ap;
}

struct amode   *
mk_areg(r)
/*
 * mk_ an address reference to an address register.
 */
    int 	    r;
{
    struct amode   *ap;
    ap = (struct amode *) xalloc((int) sizeof(struct amode));
    ap->mode = am_areg;
    ap->preg = r;
    return ap;
}

struct amode   *
mk_rmask(mask)
/*
 * generate the mask address structure.
 */
    int 	    mask;
{
    struct amode   *ap;
    ap = (struct amode *) xalloc((int) sizeof(struct amode));
    ap->mode = am_mask1;
    ap->offset = mk_icon ((long) mask);
    return ap;
}

struct amode   *
mk_smask(mask)
/*
 * generate the mask address structure.
 */
    int 	    mask;
{
    struct amode   *ap;
    ap = (struct amode *) xalloc((int) sizeof(struct amode));
    ap->mode = am_mask2;
    ap->offset = mk_icon((long) mask);
    return ap;
}


struct amode   *
mk_strlab(s)
/*
 * generate a direct reference to a string label.
 */
    char	   *s;
{
    struct amode   *ap;
    ap = (struct amode *) xalloc((int) sizeof(struct amode));
    ap->mode = am_direct;
    ap->offset = mk_node(en_nacon, NIL_ENODE, NIL_ENODE);
    ap->offset->v.sp = s;
    return ap;
}

genwhile(stmt)
/*
 * generate code to evaluate a while statement.
 */
    struct snode   *stmt;
{
    int 	    lab1, lab2;
    initstack();		/* initialize temp registers */
    lab1 = contlab;		/* save old continue label */
    lab2 = breaklab;		/* save old break label */
    contlab = nextlabel++;	/* new continue label */
#ifdef ICODE
    if (icode_option)
	fprintf(icode, "\tL%d:\n", contlab);
#endif
    g_label(contlab);
    if (stmt->s1 != 0) {	/* has block */
	breaklab = nextlabel++;
	initstack();
	falsejp(stmt->exp, breaklab);
#ifdef ICODE
	if (icode_option) {
	    fprintf(icode, "*falsejp L%d\n", breaklab);
	    g_icode(stmt->exp);
	}
#endif
	genstmt(stmt->s1);
	g_code(op_bra, 0l, mk_label(contlab), NIL_AMODE);
	g_label(breaklab);
#ifdef ICODE
	if (icode_option) {
	    fprintf(icode, "\tbranch_unconditional\tL%d\n", contlab);
	    fprintf(icode, "\tL%d:\n", breaklab);
	}
#endif
	breaklab = lab2;	/* restore old break label */
    } else {			/* no loop code */
	initstack();
	truejp(stmt->exp, contlab);
#ifdef ICODE
	if (icode_option) {
	    fprintf(icode, "*truejp L%d\n", contlab);
	    g_icode(stmt->exp);
	}
#endif
    }
    contlab = lab1;		/* restore old continue label */
}

g_for(stmt)
/*
 * generate code to evaluate a for loop
 */
    struct snode   *stmt;
{
    int 	    old_break, old_cont, exit_label, loop_label;
    old_break = breaklab;
    old_cont = contlab;
    loop_label = nextlabel++;
    exit_label = nextlabel++;
    if (stmt->v2.e != 0)
	contlab = nextlabel++;
    else
	contlab = loop_label;
    initstack();
    if (stmt->exp != 0)
	g_expr(stmt->exp, F_ALL | F_NOVALUE);
    g_label(loop_label);
#ifdef ICODE
    if (icode_option) {
	if (stmt->exp != 0)
	    g_icode(stmt->exp);
	fprintf(icode, "\tL%d:\n", loop_label);
    }
#endif
    initstack();
    if (stmt->v1.e != 0) {
	falsejp(stmt->v1.e, exit_label);
#ifdef ICODE
	if (icode_option) {
	    fprintf(icode, "*falsejp L%d\n", exit_label);
	    g_icode(stmt->v1.e);
	}
#endif
    }
    if (stmt->s1 != 0) {
	breaklab = exit_label;
	genstmt(stmt->s1);
    }
    initstack();
    if (stmt->v2.e != 0) {
	g_label(contlab);
	g_expr(stmt->v2.e, F_ALL | F_NOVALUE);
    }
    g_code(op_bra, 0l, mk_label(loop_label), NIL_AMODE);
#ifdef ICODE
    if (icode_option) {
	if (stmt->v2.e != 0) {
	    fprintf(icode,"\tL%d:\n",contlab);
	    g_icode(stmt->v2.e);
	}
	fprintf(icode, "\tbranch_unconditional\tL%d\n", loop_label);
    }
#endif
    breaklab = old_break;
    contlab = old_cont;
    g_label(exit_label);
#ifdef ICODE
    if (icode_option)
	fprintf(icode, "\tL%d:\n", exit_label);
#endif
}

genif(stmt)
/*
 * generate code to evaluate an if statement.
 */
    struct snode   *stmt;
{
    int 	    lab1, lab2, oldbreak;
    lab1 = nextlabel++; 	/* else label */
    lab2 = nextlabel++; 	/* exit label */
    oldbreak = breaklab;	/* save break label */
    initstack();		/* clear temps */
    falsejp(stmt->exp, lab1);
#ifdef ICODE
    if (icode_option) {
	fprintf(icode, "*falsejp L%d\n", lab1);
	g_icode(stmt->exp);
    }
#endif
    if (stmt->s1 != 0 && stmt->s1->next != 0)
	if (stmt->v1.s != 0)
	    breaklab = lab2;
	else
	    breaklab = lab1;
    genstmt(stmt->s1);
    if (stmt->v1.s != 0) {	/* else part exists */
	g_code(op_bra, 0l, mk_label(lab2), NIL_AMODE);
	g_label(lab1);
#ifdef ICODE
	if (icode_option) {
	    fprintf(icode, "\tbranch_unconditional\tL%d\n", lab2);
	    fprintf(icode, "\tL%d:\n", lab1);
	}
#endif
	if (stmt->v1.s == 0 || stmt->v1.s->next == 0)
	    breaklab = oldbreak;
	else
	    breaklab = lab2;
	genstmt(stmt->v1.s);
	g_label(lab2);
#ifdef ICODE
	if (icode_option)
	    fprintf(icode, "\tL%d:\n", lab2);
#endif
    } else {			/* no else code */
	g_label(lab1);
#ifdef ICODE
	if (icode_option)
	    fprintf(icode, "\tL%d:\n", lab1);
#endif
    }
    breaklab = oldbreak;
}

gendo(stmt)
/*
 * generate code for a do - while loop.
 */
    struct snode   *stmt;
{
    int 	    oldcont, oldbreak;
    oldcont = contlab;
    oldbreak = breaklab;
    contlab = nextlabel++;
    g_label(contlab);
#ifdef ICODE
    if (icode_option)
	fprintf(icode, "\tL%d:\n", contlab);
#endif
    breaklab = nextlabel++;
    genstmt(stmt->s1);		/* generate body */
    initstack();
    truejp(stmt->exp, contlab);
    g_label(breaklab);
#ifdef ICODE
    if (icode_option) {
	fprintf(icode, "*truejp L%d\n", contlab);
	g_icode(stmt->exp);
	fprintf(icode, "\tL%d:\n", breaklab);
    }
#endif
    breaklab = oldbreak;
    contlab = oldcont;
}

call_library(lib_name)
/*
 * generate a call to a library routine.
 */
    char	   *lib_name;
{
    SYM 	   *sp;
    sp = gsearch(lib_name);
    if (sp == 0) {
	++global_flag;
	sp = (SYM *) xalloc((int) sizeof(SYM));
	sp->tp = 0;
	sp->name = lib_name;
	sp->storage_class = sc_external;
	append(&sp, &gsyms);
	--global_flag;
    }
    sp->used = 1;
    g_code(op_jsr, 0l, mk_strlab(lib_name), NIL_AMODE);
}

genswitch(stmt)
/*
 * generate a linear search switch statement.
 */
    struct snode   *stmt;
{
    int 	    curlab;
    struct snode   *defcase;
    struct amode   *ap;
    long	    size;
    defcase = 0;
    initstack();
    ap = g_expr(stmt->exp, F_DREG | F_VOL);
    size = stmt->exp->esize;
#ifdef ICODE
    if (icode_option) {
	fprintf(icode, "$switchexp\n");
	g_icode(stmt->exp);
    }
#endif
    stmt = stmt->s1;
    while (stmt != 0) {
	curlab = nextlabel++;
	if (stmt->stype == st_default) {	/* default case ? */
	    defcase = stmt;
	} else {
	    g_code(op_cmp, size, mk_immed((long)stmt->v2.i), ap);
	    g_code(op_beq, 0l, mk_label(curlab), NIL_AMODE);
#ifdef ICODE
	    if (icode_option)
		fprintf(icode, "*ifeq\t%d,L%d\n", stmt->v2.i, curlab);
#endif
	}
	stmt->v2.i = curlab;
	stmt = stmt->s1;
    }
    if (defcase == 0) {
	g_code(op_bra, 0l, mk_label(breaklab), NIL_AMODE);
#ifdef ICODE
	if (icode_option)
	    fprintf(icode, "\tbranch_unconditional\tL%d\n", breaklab);
#endif
    } else {
	g_code(op_bra, 0l, mk_label(defcase->v2.i), NIL_AMODE);
#ifdef ICODE
	if (icode_option)
	    fprintf(icode, "\tbranch_unconditional\tL%d\n", defcase->v2.i);
#endif
    }
}

gencase(stmt)
/*
 * generate the label for the case statement.
 */
    struct snode   *stmt;
{
    g_label(stmt->v2.i);
#ifdef ICODE
    if (icode_option)
	fprintf(icode, "\tL%d:\n", stmt->v2.i);
#endif
}

genxswitch(stmt)
/*
 * analyze and generate best switch statement.
 */
    struct snode   *stmt;
{
    int 	    oldbreak;
    oldbreak = breaklab;
    breaklab = nextlabel++;
    genswitch(stmt);
    genstmt(stmt->v1.s);
    g_label(breaklab);
#ifdef ICODE
    if (icode_option)
	fprintf(icode, "\tL%d:\n", breaklab);
#endif
    breaklab = oldbreak;
}

genreturn(stmt)
/*
 * generate a return statement.
 */
    struct snode   *stmt;
{
    struct amode   *ap;
    if (stmt != 0 && stmt->exp != 0) {
	initstack();
	/* evaluate a parameter in D0 */
	ap = g_expr(stmt->exp, F_ALL);
	if (ap->mode != am_dreg || ap->preg != 0)
	    g_code(op_move, stmt->exp->esize, ap, mk_dreg(0));
#ifdef ICODE
	if (icode_option) {
	    fprintf(icode, "$reg D0\n");
	    g_icode(stmt->exp);
	}
#endif
    }
    if (retlab == -1) {
	retlab = nextlabel++;
	g_label(retlab);
#ifdef ICODE
	if (icode_option)
	    fprintf(icode, "\tL%d:\n", retlab);
#endif
	if (save_mask != 0)
	    g_code(op_movem, 4l, pop, mk_smask(save_mask));
	g_code(op_unlk, 0l, mk_areg(6), NIL_AMODE);
	g_code(op_rts, 0l, NIL_AMODE, NIL_AMODE);
#ifdef ICODE
	if (icode_option) {
	    if (save_mask != 0)
		fprintf(icode, "\t$regpop %04x\n", save_mask);
	    fprintf(icode, "\t$leave\n");
	}
#endif
    } else {
	g_code(op_bra, 0l, mk_label(retlab), NIL_AMODE);
#ifdef ICODE
	if (icode_option)
	    fprintf(icode, "\tbranch_unconditional\tL%d\n", retlab);
#endif
    }
}

genstmt(stmt)
/*
 * genstmt will generate a statement and follow the next pointer until the
 * block is generated.
 */
    struct snode   *stmt;
{
    while (stmt != 0) {
	switch (stmt->stype) {
	case st_label:
	    g_label(stmt->v2.i);
#ifdef ICODE
	    if (icode_option)
		fprintf(icode, "\tL%d:\n", stmt->v2.i);
#endif
	    genstmt(stmt->s1);
	    break;
	case st_goto:
	    g_code(op_bra, 0l, mk_label(stmt->v2.i), NIL_AMODE);
#ifdef ICODE
	    if (icode_option)
		fprintf(icode, "\tbranch_unconditional\tL%d\n", stmt->v2.i);
#endif
	    break;
	case st_expr:
	    initstack();
	    g_expr(stmt->exp, F_ALL | F_NOVALUE);
#ifdef ICODE
	    if (icode_option)
		g_icode(stmt->exp);
#endif
	    break;
	case st_return:
	    genreturn(stmt);
	    break;
	case st_if:
	    genif(stmt);
	    break;
	case st_while:
	    genwhile(stmt);
	    break;
	case st_do:
	    gendo(stmt);
	    break;
	case st_for:
	    g_for(stmt);
	    break;
	case st_continue:
	    g_code(op_bra, 0l, mk_label(contlab), NIL_AMODE);
#ifdef ICODE
	    if (icode_option)
		fprintf(icode, "\tbranch_unconditional\tL%d\n", contlab);
#endif
	    break;
	case st_break:
	    g_code(op_bra, 0l, mk_label(breaklab), NIL_AMODE);
#ifdef ICODE
	    if (icode_option)
		fprintf(icode, "\tbranch_unconditional\tL%d\n", breaklab);
#endif
	    break;
	case st_switch:
	    genxswitch(stmt);
	    break;
	case st_compound:
	    genstmt(stmt->s1);
	    break;
        case st_case:
	case st_default:
	    gencase(stmt);
	    genstmt(stmt->v1.s);
	    break;
	default:
	    fprintf(stderr,"DIAG - unknown statement.\n");
	    break;
	}
	stmt = stmt->next;
    }
}

genfunc(stmt)
/*
 * generate a function body.
 */
    struct snode   *stmt;
{
    retlab = contlab = breaklab = -1;
/*DEFAULTALIGNMENT*/
    if (max_auto & 1)		/* if frame size odd */
	++max_auto;		/* make it even */
    if (max_auto <32768)
	g_code(op_link, 0l, mk_areg(6), mk_immed((long)-max_auto));
    else {
	g_code(op_pea,0l,mk_areg(6),NIL_AMODE);
	g_code(op_move,4l,mk_areg(7),mk_areg(6));
	g_code(op_sub,4l,mk_immed(max_auto),mk_areg(7));
    }
#ifdef ICODE
    if (icode_option)
	fprintf(icode, "\t$frame %ld\n", -max_auto);
#endif
    opt1(stmt);
    genstmt(stmt);
    genreturn(NIL_SNODE);
}
