#ifdef ICODE
#include	<stdio.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

/*
 * this module contains all of the code generation routines for evaluating
 * expressions and conditions.
 */

static char    *
type(node)
    struct enode   *node;
{
    switch (node->etype) {
    case bt_char:
	return ("char");
    case bt_uchar:
	return ("unsigned char");
    case bt_short:
	return ("short");
    case bt_ushort:
	return ("unsigned short");
    case bt_long:
	return ("long");
    case bt_ulong:
	return ("unsigned long");
    case bt_pointer:
	return ("pointer");
    case bt_struct:
    case bt_union:
	return ("struct/union");
    case bt_func:
	return ("function");
    case bt_double:
    case bt_float:
	return ("float");
    case bt_void:
	return ("void");
    case bt_enum:
	return ("enum");
    default:
	fprintf(stderr,"DIAG: type: unknown\n");
	return ("UNKNOWN");
    }
}

g_icode(node)
/*
 * general expression evaluation. symbolic dump.
 */
    struct enode   *node;
{
    if (node == 0) {
	fprintf(stderr,"DIAG - null node in g_icode.\n");
	fprintf(icode, "*NULL\n");
	return 0;
    }
#define gen0 g_icode(node->v.p[0])
#define gen1 g_icode(node->v.p[1])
#define typ  type(node)
#define size node->esize

    switch (node->nodetype) {
    case en_icon:
	fprintf(icode, "*icon %s %ld %ld\n", typ, size, node->v.i);
	break;
    case en_labcon:
	fprintf(icode, "*labcon %s %ld L%ld\n",
		typ, size, node->v.i);
	break;
    case en_nacon:
	fprintf(icode, "*nacon %s %ld %s\n", typ, size,
		node->v.sp);
	break;
    case en_fcon:
	fprintf(icode, "*fcon %20.10lf\n", node->v.f);
	break;
    case en_autocon:
	fprintf(icode, "*autocon %s %ld %ld\n", typ, size, node->v.i);
	break;
    case en_ref:
	fprintf(icode, "*ref %s %ld\n", typ, size);
	gen0;
	break;
    case en_tempref:
	fprintf(icode, "*tempref %s %ld", typ, size);
	if (node->v.i < 8)
	    fprintf(icode, " D%ld\n", node->v.i);
	else
	    fprintf(icode, " A%ld\n", node->v.i - 8);
	break;
    case en_uminus:
	fprintf(icode, "*uminus %s %ld\n", typ, size);
	gen0;
	break;
    case en_compl:
	fprintf(icode, "*compl %s %ld\n", typ, size);
	gen0;
	break;
    case en_add:
	fprintf(icode, "*add %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_sub:
	fprintf(icode, "*sub %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_and:
	fprintf(icode, "*and %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_or:
	fprintf(icode, "*or %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_xor:
	fprintf(icode, "*xor %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_mul:
	fprintf(icode, "*mul %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_div:
	fprintf(icode, "*div %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_mod:
	fprintf(icode, "*mod %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_lsh:
	fprintf(icode, "*lsh %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_rsh:
	fprintf(icode, "*rsh %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_asadd:
	fprintf(icode, "*asadd %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_assub:
	fprintf(icode, "*assub %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_asand:
	fprintf(icode, "*asand %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_asor:
	fprintf(icode, "*asor %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_aslsh:
	fprintf(icode, "*aslsh %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_asrsh:
	fprintf(icode, "*asrsh %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_asmul:
	fprintf(icode, "*asmul %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_asdiv:
	fprintf(icode, "*asdiv %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_asmod:
	fprintf(icode, "*asmod %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_assign:
	fprintf(icode, "*assign %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_ainc:
	fprintf(icode, "*ainc %s %ld value=%ld\n",
		typ, size, node->v.p[1]->v.i);
	gen0;
	break;
    case en_adec:
	fprintf(icode, "*adec %s %ld value=%ld\n",
		typ, size, node->v.p[1]->v.i);
	gen0;
	break;
    case en_land:
	fprintf(icode, "*land\n");
	gen0;
	gen1;
	break;
    case en_lor:
	fprintf(icode, "*lor\n");
	gen0;
	gen1;
	break;
    case en_eq:
	fprintf(icode, "*eq %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_ne:
	fprintf(icode, "*ne %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_lt:
	fprintf(icode, "*lt %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_le:
	fprintf(icode, "*le %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_gt:
	fprintf(icode, "*gt %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_ge:
	fprintf(icode, "*ge %s %ld\n", typ, size);
	gen0;
	gen1;
	break;
    case en_not:
	fprintf(icode, "*not %s %ld\n", typ, size);
	gen0;
	break;
    case en_cond:
	fprintf(icode, "*cond %s %ld\n", typ, size);
	gen0;
	node = node->v.p[1];
	gen0;
	gen1;
	break;
    case en_void:
	fprintf(icode, "*void %s %ld\n", typ, size);
	gen0;
	if (node->v.p[1] != 0)
	    gen1;
	else
	    fprintf(icode, "*null\n");
	break;
    case en_fcall:
	fprintf(icode, "*fcall %s %ld\n", typ, size);
	gen0;
	if (node->v.p[1] != 0)
	    gen1;
	else
	    fprintf(icode, "*null\n");
	break;
    case en_cast:
	fprintf(icode, "*cast %s %ld\n", typ, size);
	gen0;
	break;
    default:
	fprintf(stderr,"DIAG - uncoded node in g_icode:%ld\n",
	       node->nodetype);
	fprintf(icode, "*???\n");
    }
return 0;
}
#endif
