/*
 * code generation structures and constants
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

#define F_DREG	1		/* data register direct mode allowed */
#define F_AREG	2		/* address register direct mode allowed */
#define F_MEM	4		/* memory alterable modes allowed */
#define F_IMMED 8		/* immediate mode allowed */
#define F_ALT	7		/* alterable modes */
#define F_DALT	5		/* data alterable modes */
#define F_ALL	15		/* all modes allowed */
#define F_VOL	16		/* need volitile operand */
#define F_NOVALUE 32		/* dont need result value */
#define F_USES	  64		/* need result value more than once */
				/* this forbids autoincrement modes */

#define MAX_ADDR 1		/* max. scratch address register (A1) */
#define MAX_DATA 2		/* max. scratch data	register (D2) */

enum e_op {
    op_move, op_moveq, op_add, op_addi, op_addq, op_sub, op_subi,
    op_subq, op_muls, op_mulu, op_divs, op_divu, op_and, op_andi,
    op_or, op_ori, op_eor, op_asl, op_asr, op_jmp, op_jsr, op_movem,
    op_rts, op_bra, op_beq, op_bne, op_blt, op_ble, op_bgt, op_bge,
    op_bhi, op_bhs, op_blo, op_bls, op_tst, op_ext, op_lea, op_swap,
    op_neg, op_not, op_cmp, op_clr, op_link, op_unlk, op_label,
    op_pea, op_cmpi, op_dbra
};

enum e_am {
    am_dreg, am_areg, am_ind, am_ainc, am_adec, am_indx, am_indx2,
    am_direct, am_immed, am_mask1, am_mask2,
    am_none, am_indx3
};

/* addressing mode structure	 */

struct amode {
    enum e_am	    mode;
    short	    preg;
    short	    sreg;
    short	    tempflag;
    short	    deep;	/* stack depth on allocation */
    struct enode   *offset;
};

#define NIL_AMODE ( (struct amode *) 0)
/* output code structure	 */

struct ocode {
    struct ocode   *fwd, *back;
    enum e_op	    opcode;
    short	    length;
    struct amode   *oper1, *oper2;
};

struct amode   *g_expr();
struct amode   *mk_areg();
struct amode   *mk_dreg();
struct amode   *temp_data();
struct amode   *temp_addr();
struct amode   *mk_offset();
struct amode   *g_cast();
struct amode   *g_fcall();
struct amode   *func_result();
struct amode   *as_fcall();
struct amode   *mk_rmask();
struct amode   *mk_smask();
struct amode   *mk_label();
struct amode   *mk_strlab();
struct amode   *mk_immed();
