#include	<stdio.h>
#include	<signal.h>
#include	"c.h"
#include	"expr.h"
#include	"gen.h"
#include	"cglbdec.h"

/*
 * 68000 C compiler
 *
 * Copyright 1984, 1985, 1986 Matthew Brandt. all commercial rights reserved.
 *
 * This compiler is intended as an instructive tool for personal use. Any use
 * for profit without the written consent of the author is prohibited.
 *
 * This compiler may be distributed freely for non-commercial use as long as
 * this notice stays intact. Please forward any enhancements or questions to:
 *
 * Matthew Brandt Box 920337 Norcross, Ga 30092
 *
 * This compiler has been enhanced and corrected at the end of 1989 by Christoph
 * van Wullen, who generated this version. Look at the file README.CVW for
 * further comments.
 */

extern int	total_errors;



static
exception(sig)
    int 	    sig;
{
    fprintf(stderr,"\n\nSIGNAL %d -- TERMINATING.\n", sig);
    exit(16);
}

#ifndef _NSIG
#define _NSIG	NSIG
#endif

main(argc, argv)
    int 	    argc;
    char	  **argv;
{
    int 	    i;

    for (i = 1; i < _NSIG; ++i)
	signal(i, exception);

    while ((--argc > 0) && **++argv == '-') {
	options(*argv);
    }


	openfiles(argc,argv);
	/* return means that all files have been opened */
	out_init();
	lineno = 0;
	initsym();
	getch();
	getsym();
	compile();
	if (list_option)
	    summary();
	else
	    /* This emits all the global and external directives */
	    list_table(&gsyms, 0);
	fprintf(stderr,"\n -- %d errors found.\n", total_errors);
	rel_global();
	closefiles();
	if (total_errors>0) exit(1); else exit(0);
}

int
options(s)
    char	   *s;
{
    ++s;
    if (!strcmp(s, "list")) {
	list_option = 1;
	return;
    }
    if (!strcmp(s, "noshort")) {
	short_option = 0;
	return;
    }
    if (!strcmp(s, "short")) {
	short_option = 1;
	return;
    }
    if (!strcmp(s, "noreg")) {
	noreg_option = 1;
	return;
    }
    if (!strcmp(s, "trans")) {
	trans_option = 1;
	return;
    }
#ifdef ICODE
    if (!strcmp(s, "icode")) {
	icode_option = 1;
	return;
    }
#endif
    fprintf(stderr,"warning: unknown option %s ignored.\n", --s);
}

int
openfiles(argc,argv)
int argc;
char **argv;
{
    if (argc < 2) {
	fprintf(stderr,"input and output filename required\n");
	exit (2);
    }
    if ((input = fopen(*argv++,"r")) == NULL) {
	fprintf(stderr,"cant open input file\n");
	exit(2);
    }
    if ((output = fopen(*argv++,"w")) == NULL) {
	fprintf(stderr,"cant open output file\n");
	exit(2);
    }
    if (list_option && (list = fopen("c68.list", "w")) == 0) {
	fprintf(stderr," cant open listfile\n");
	exit(1);
    }
#ifdef ICODE
    if (icode_option && ((icode = fopen("c68.icode", "w")) == 0)) {
	fprintf(stderr," cant open icode file\n");
	exit(1);
    }
#endif
}

summary()
{
    if (gsyms.head != NULL) {
	fprintf(list, "\f\n *** global scope symbol table ***\n\n");
	list_table(&gsyms, 0);
    }
    if (gtags.head != NULL) {
	fprintf(list, "\n *** structures and unions ***\n\n");
	list_table(&gtags, 0);
    }
}

closefiles()
{
    if (list_option)
	fclose(list);
#ifdef ICODE
    if (icode_option)
	fclose(icode);
#endif
}
