/*
 *	@(#)agcpp.c	1.12	09/02/89	18:22:10	agc
 *
 *	Copyright Joypace Ltd, UK, 1989. All rights reserved.
 *	This file may be freely distributed provided that this
 *	notice remains attached.
 *
 *	agcpp - a version of a C pre-processor.
 *
 *	agcpp.c - miscellaneous routines, and main.
 *
 *	Compile time flags:
 *	ATT		Unix System V.[23]
 *	BSD		Unix BSD4.[23]
 *	ZORTECH		Zortech C++, v1.05
 *	TURBOC		Turbo C, 1.5
 *	MSC		Microsoft C, 5.0
 *	MINIX		Minix 1.2
 */
#ifndef lint
char	*agcppnsccsid = "@(#)agcpp.c	1.12 09/02/89 18:22:10 agc";
#endif /* not lint */

#include <stdio.h>
#include <ctype.h>

#define EXTERN
#include "defs.h"

#ifdef ATT
#ifndef STDINCLUDE
#define STDINCLUDE	"/usr/include"
#endif /* STDINCLUDE */
#define OSTYPE		"unix"
#endif /* ATT */

#ifdef BSD
#ifndef STDINCLUDE
#define STDINCLUDE	"/usr/include"
#endif /* STDINCLUDE */
#define OSTYPE		"unix"
#endif /* BSD */

#ifdef ZORTECH
#ifndef STDINCLUDE
#define STDINCLUDE	"c:/zortech/include"
#endif /* STDINCLUDE */
#define OSTYPE		"dos"
#endif /* ZORTECH */

#ifdef TURBOC
#ifndef STDINCLUDE
#define STDINCLUDE	"c:/turboc/include"
#endif /* STDINCLUDE */
#define OSTYPE		"dos"
#endif /* TURBOC */

#ifdef MSC
#ifndef STDINCLUDE
#define STDINCLUDE	"c:/msc/include"
#endif /* STDINCLUDE */
#define OSTYPE		"dos"
#endif /* MSC */

#ifdef MINIX
#ifndef STDINCLUDE
#define STDINCLUDE 	"/usr/include"
#endif /* STDINCLUDE */
#define OSTYPE		"minix"
#endif /* MINIX */

#ifndef PROCESSOR
#define PROCESSOR	"i8088"
#endif /* PROCESSOR */

#define READING	1
#define WRITING	2

typedef struct directive {
	char	*d_name;
	int	d_type;
#define UNKNOWN	0
#define	DEFINE	1
#define	ENDIF	2
#define	IFDEF	3
#define	IFNDEF	4
#define	ELSE	5
#define	INCLUDE	6
#define	IF	7
#define	ELIF	8
#define	UNDEF	9
#define	PRAGMA	10
#define	ERROR	11
#define	LINE	12
#define	IDENT	13
#define EMPTY	14
} DIRECTIVE;

static DIRECTIVE	directives[] = {
	"define",	DEFINE,
	"endif",	ENDIF,
	"ifdef",	IFDEF,
	"ifndef",	IFNDEF,
	"else",		ELSE,
	"include",	INCLUDE,
	"if",		IF,
	"elif",		ELIF,
	"undef",	UNDEF,
	"pragma",	PRAGMA,
	"error",	ERROR,
	"line",		LINE,
#ifdef IDENT_DIR
	"ident",	IDENT,
#endif /* IDENT_DIR */
	"\n",		EMPTY,
	NULL
};

static char	*one = "1";		/* string for definitions */
static char	linedirectives = 1;	/* 1 = line directives are made */

extern char	*optarg;
extern int	optind;


/* report an error on stderr, and exit if n greater than 0 */
void
error(n, fmt, s)
int	n;
char	*fmt;
char	*s;
{
	if (filename[0])
		(void) fprintf(stderr, "\"%s\" ", filename);
	(void) fprintf(stderr, "%d: ", lineno);
	(void) fprintf(stderr, fmt, s);
	(void) fputc('\n', stderr);
	if (n)
		(void) exit(n);
}


/* Minix has no bzero function - to zero n bytes of s */
#ifdef MINIX
void
bzero(s, n)
char	*s;
unsigned int	n;
{
	while (n--)
		*s++ = 0;
}
#endif /* MINIX */


/* save n chars of s in malloc'd memory */
char *
strnsave(s, n)
char	*s;
int	n;
{
	char	*cp;

	NEWARRAY(char, cp, n+1);
	(void) strncpy(cp, s, n);
	cp[n] = 0;
	return(cp);
}


/* put n tokens of s on stdout */
void
output(s, n)
char	*s;
int	n;
{
	static char	obuf[BUFSIZ];
	static char	*op = obuf;
	char		*was;
	char		*cp;

	(void) strncpy(op, s, n);
	op += n;
	*op = 0;
	if (s[n-1] == '\n') {
		for (cp = op = obuf ; *op ; ) {
			while (*op && *op != '"')
				*cp++ = *op++;
			if (*op == 0)
				break;
			for (*cp++ = *op++ ; *op && *op != '"' ; *cp++ = *op++)
				if (*op == '\\')
					*cp++ = *op++;
			if (*op == 0)
				break;
			for (was = op++ ; *op && isspace(*op) ; op++)
				;
			if (*op == 0)
				break;
			if (*op == '"')
				op++;
			else
				op = was;
		}
		for (*cp-- = 0 ; cp != obuf && isspace(*cp) ; --cp)
			;
		if (*cp == '"')
			op = &obuf[strlen(obuf) - 1];
		else {
			(void) fputs(obuf, stdout);
			op = obuf;
		}
	}
}


/* delete an ARGS structure */
void
delargs(ap)
ARGS	*ap;
{
	int	i;

	for (i = 0 ; i < ap->a_argc ; i++)
		(void) nfree((char *) ap->a_argv[i]);
	(void) nfree((char *) ap);
}


/* perform the line directive */
void
doline()
{
	if (linedirectives)
		(void) printf("# %d \"%s\"\n", lineno, filename);
}


#ifdef IDENT_DIR
/* perform the ident directive */
void
doident(fp)
FILE	*fp;
{
	(void) printf("# ident ");
	if (!gettoken(fp, 1, &t))
		error(0, "Unexpected end of file in #ident", (char *) NULL);
	(void) printf("%s\n", t.t_token);
}
#endif /* IDENT_DIR */


/* perform the error directive */
void
doerror(fp)
FILE	*fp;
{
	tmp[0] = 0;
	while (gettoken(fp, 0, &t)) {
		if (t.t_type == T_EOLN)
			break;
		(void) strcat(tmp, t.t_token);
	}
	error(1, "%s", tmp);
}


/* perform the undef directive */
void
doundef(fp)
FILE	*fp;
{
	if (!gettoken(fp, 0, &t))
		error(1, "Bad undef syntax", (char *) NULL);
	delmacro(t.t_token);
}


/* check that we're not at the top level */
int
oklevel(level, directive)
int	level;
char	*directive;
{
	if (level == 0)
		error(0, "Unmatched %s", directive);
	return(level != 0);
}


/* check that we've not seen an else directive yet */
int
okelse(elseln)
int	elseln;
{
	if (elseln >= 0)
		error(0, "Previous #else directive line %d", (char *) elseln);
	return(elseln < 0);
}


/* find out which directive it was from directives despatch table */
int
getdirective(s)
char	*s;
{
	DIRECTIVE	*dp;

	for (dp = directives ; dp->d_name ; dp++)
		if (STREQ(dp->d_name, s))
			return(dp->d_type);
	return(UNKNOWN, e                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     