/************************************************************************
 * *** Diepbom ***     ir. W.C.A. van Dorst (C) 1987 's-Gravenhage      *
 * Version 1.0 for MSDos, December 1987, from an idea in Basic          *
 * Version 1.1 for Minix, Sept 1991 (C) by Wim `Blue Baron' van Dorst   *
 ************************************************************************/

#include <sys/types.h>
#include <sgtty.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define TRUE        1		/* this is "true" */
#define FALSE       0		/* and thus this is "not true" */
#define N_SUB_MAX   5		/* maximum number submarines */
#define N_BOMB_MAX  5		/* maximum number bombes */
#define PUNT_PER_LEVEL  75	/* minimal score */
#define SCOREFILE	"/usr/games/diepbom.scr"

/* video control for VT100/ANSI */
#define cursor(line, column) printf("\033[%d;%dH", line, column)
#define CLRSRCN 	"\033[H\033[J"	/* clearscreen */
#define HI_VID 		"\033[1m"	/* highlighted video */
#define NM_VID 		"\033[0m"	/* normal video */
#define CURSOR_OFF 	"\033[?25l"	/* cursor off */		
#define CURSOR_ON 	"\033[?25h"

/* coordinates */
int x_sub[N_SUB_MAX],		/* column submarine end */
 y_sub[N_SUB_MAX],		/* line submarine end */
 x_bomb[N_BOMB_MAX],		/* column bomb */
 y_bomb[N_BOMB_MAX],		/* line bomb */
 x_ship;			/* column ship head */

/* terminal structures */
struct sgttyb raw_tty;		/* tty during raw mode */
struct sgttyb original_tty;	/* tty before and after */

/* Diepbom Expert */
char db_expert[16];		/* contains the name of the expert */

/*************************************************************************/
main()
{
	int again = TRUE;

	init_terminal();		/* initialize terminal */
	instructions();			/* show instructions */

	while (again) {
		init();			/* initial placing of submarines */
		while (move_ship()) {	/* while the ship can be moved */
			drop_bomb();	/* has one dropped a bomb */
			move_subs();	/* move the submarines */
			drop_bomb();
			move_bombs();	/* move the bombes */
			drop_bomb();
			move_subs();	/* move the submarines again */
			drop_bomb();
		}
		again = print_score();	/* note the score in the scorefile */
	}

	clean_up();		/* clean up the mess afterwards */
}

/*************************************************************************/
init_terminal()	 				/* initialize terminal */
{
	/* raw mode on */
	ioctl(0, TIOCGETP, &original_tty);	/* current setting */
	ioctl(0, TIOCGETP, &raw_tty);		/* again */
	raw_tty.sg_flags &= ~(ECHO | CRMOD);	/* echo off */
	raw_tty.sg_flags |= CBREAK;		/* raw on    */
	ioctl(0, TIOCSETP, &raw_tty);		/* set new setting */

	/* non-blocking reads */	
	fcntl(0, F_SETFL, O_NONBLOCK);		

	/* cursor off */
	printf(CURSOR_OFF);			

	/* catch signals */
	signal(SIGINT, clean_up);
}

/**************************************************************************/
exit_terminal()					/* normalize terminal */
{
	/* non-blocking reads off */
	fcntl(0, F_SETFL, O_ACCMODE);

	/* raw mode off */
	ioctl(0, TIOCSETP, &original_tty);

	/* cursor on */
	printf(CURSOR_ON);
}

/*************************************************************************/
instructions()	 			/* explanations on the game */
{
	char *p_db_expert;
	if (p_db_expert = getenv("DIEPBOM_EXPERT"))
		strncpy(db_expert, p_db_expert, 16);
	if (*db_expert) return;

	/* for the instructions blocked reads */
	fcntl(0, F_SETFL, O_ACCMODE);

	printf("Do you want explanations on *** Diepbom ***\r\n");
	printf("Type in y or n: %sn%s\b", HI_VID, NM_VID);
	if (readch() != 'y') {
		fcntl(0, F_SETFL, O_NONBLOCK);
		return;
	}

	printf(CLRSRCN);
	cursor(1, 35);
	printf("*** Diepbom ***\r\n\r\n");

	printf("PURPOSE: Destroy as many submarines as possible and gain as many points\r\n");
        printf("         as needed to get in the top 20.\r\n\r\n");

	printf("METHOD:  Drop one of your %d bombs by pushing a key\r\n\r\n", N_BOMB_MAX);

	printf("SCORING: Hits give you the number of points equal to the depth of the\r\n");
	printf("         submarine, thus 19 points when you hit a submarine on line 19.\r\n");
	printf("         If you hit a submarine on its bridge you get 15 Bonus points.\r\n");
	printf("         On dying (hitting the #) you lose 25 points.\r\n\r\n");

	printf("FINISH:  You have to amass points per level, increasingly from %d adding 2\r\n", PUNT_PER_LEVEL);
	printf("         per level [%dn+n(n-1)]. In the end a # shows up in the left upper \r\n", PUNT_PER_LEVEL);
	printf("         corner to indicate that you are falling behind. When your ship hits\r\n");
	printf("         the #, the game is ended. If your score is high enough it shall be\r\n");
	printf("         enlisted in the score file %s.\r\n\r\n", SCOREFILE);

	printf("DIEPBOM_EXPERT: When you don't need these instructions any more, you can set\r\n");
	printf("         the environment variable DIEPBOM_EXPERT to your name, e.g., in your\r\n");
	printf("         profile. Then you won't be asked about the instructions, and the\r\n");
	printf("         name is used in the scorelist, so you won't have to type it any more. \r\n");
	printf("         Note the Dutch spelling of the variable, though.\r\n");
	
	printf("Press any key to continue");
	readch();
	fcntl(0, F_SETFL, O_NONBLOCK);
}

/*************************************************************************/
init()					/* initial placing of submarines */
{				
	int n_sub, n_bomb, i;
	long ltime;

	/* put the submarine */
	srand((unsigned int) (time(&ltime) % 100L));
	for (n_sub = 0; n_sub < N_SUB_MAX; n_sub++) {
		x_sub[n_sub] = rand() % 80 + 2;
		y_sub[n_sub] = rand() % 20 + 5;
	}

	/* put the bombes in the ship */
	for (n_bomb = 0; n_bomb < N_BOMB_MAX; n_bomb++)
		y_bomb[n_bomb] = 1;

	/* put the ship */
	x_ship = 75;

	/* draw the sea */
	printf(CLRSRCN);
	for (i = 0; i < 80; i++)
		printf("_");

	/* score sofar: nothing of course */
	calc_score(0, 0);
}

/*************************************************************************/
int calc_score(score_add, level_add)	/* Calculate new score and level */
int score_add, level_add;
{
/* Return value is	TRUE	when the score is high enough to do this sea
 *			FALSE	when the score is not high enough
 *			score	when score_add==-1 for score_print()
 *			level	when score_add==-2 for move_subs()
 */

	static int score = 0;	/* number of point */
	static int level = 1;	/* number of seas passed */
	static int min_score = 57;	/* minimal score for continuation */

	/* retourneer de score of level */
	if (score_add == -1) {
		score_add = score;	/* waarde van score bewaren */
		score = 0;	/* score terugzetten */
		level = 1;	/* level terugzetten */
		min_score = 57;	/* min_score terugzetten */
		return (score_add - 25);	/* 25 strafpunten voor
						 * doodgaan */
	} else if (score_add == -2)
		return (level);

	score += score_add;	/* winst erbij optellen */
	if (level_add) {	/* volgende zeetje */
		level += level_add;	/* eentje erbij */
		min_score += PUNT_PER_LEVEL + 2 * level;	/* progressief */
	}
	/* druk de score af */
	cursor(1, 74);
	printf("%d/%d", score, level);

	/* controleer of dit zeetje het laatste schijnt */
	cursor(1, 1);
	if (level > 3) {	/* de eerste vier gratis */
		if (score < min_score) {	/* jammer, niet verder */
			printf("%s#%s", HI_VID, NM_VID);
			return (FALSE);
		} else {	/* Ok, mag verder */
			printf("_");
			return (TRUE);
		}
	}
}

/*************************************************************************/
int move_ship()
{				/* probeer het schip te verplaatsen */
	/* links aangekomen */
	if (--x_ship == 0) {
		if (!calc_score(0, 0))
			return (FALSE);
		cursor(1, 1);
		printf("_______");
		x_ship = 74;
		calc_score(0, 1);
	}
	cursor(1, x_ship);
	printf("\315\317\315\315\367\367_");

	/* er is plaats om de score af te drukken */
	if (x_ship == 68)
		calc_score(0, 0);

	return (TRUE);
}

/*************************************************************************/
move_subs()
{				/* verplaats de onderzeeers */

/* Bij het verplaatsen van de onderzeeers dient het volgende in acht
 * te worden genomen. Indien een schip een stapje doet kan het tegen
 * een bom opvaren in de column voor het schip. Eigenlijk hoeft alleen
 * maar die column gecontroleerd te worden, maar voor toekomstige
 * uitbreidingen naar ook verticale verplaatsingen van onderzeeers
 * wordt nu teveel gecontroleerd, namelijk of ergens de onderzeeer
 * geraakt wordt.
 * Er lijkt ook een hit te zijn als een bom voor het schip langs valt,
 * maar dat komt omdat eerst de onderzeeer numeriek wordt verplaats, dan
 * de hit wordt bepaald, en dan pas de verplaatste (of nieuwe, na een
 * explosie) onderzeeer wordt afgedrukt.
 */

	int x_max, x_min, y, n_sub, n_bomb, omhoog;

	for (n_sub = 0; n_sub < N_SUB_MAX; n_sub++) {

		x_min = ++x_sub[n_sub];
		y = y_sub[n_sub];

		/* misschien omhoog of omlaag?? */
		if (calc_score(-2) > 6) {	/* pas boven level 6 */
			if ((omhoog = (rand() % 100)) > 95) {	/* 4% kans omlaag */
				cursor(y, x_min - 1);	/* uitvegen nu nog oude */
				printf("      ");	/* plaats nog bekend is */
				if (y < 22)	/* niet te diep zinken */
					y = ++y_sub[n_sub];
			} else if (omhoog < 4) {	/* 4% kans omhoog */
				cursor(y, x_min - 1);	/* uitvegen */
				printf("      ");
				if (y > 5)	/* niet te hoog */
					y = --y_sub[n_sub];
			}
		}
		/* sub 0 gaat niet vooruit (wel omhoog of omlaag) */
		if (n_sub == 0)
			x_min == --x_sub[0];

		/* onderzeeer loopt van het scherm af */
		if (x_min > 73) {
			/* oude onderzeeer uitvegen */
			cursor(y, x_min - 1);
			printf("     ");
			/* onderzeeer gaat links weer verder */
			x_sub[n_sub] = 2;
			x_min = x_sub[n_sub];
		}
		/* controleer op een hit */
		x_max = x_min + 4;	/* sub is 5 lang */
		for (n_bomb = 0; n_bomb < N_BOMB_MAX; n_bomb++)
			if (y_bomb[n_bomb] == y &&
			    x_bomb[n_bomb] >= x_min &&
			    x_bomb[n_bomb] <= x_max) {
				/* raak!!!! */
				explode(x_min - 1, y, n_sub);
				cursor(y_bomb[n_bomb], x_bomb[n_bomb]);
				printf(" ");
				y_bomb[n_bomb] = 1;
			}
		/* druk de verplaatste onderzeeer af */
		cursor(y_sub[n_sub], x_sub[n_sub] - 1);
		printf(" \304\320\304\304\304");
	}
}

/************************************************************************/
move_bombs()
{				/* verplaats de bommen */
/* Verplaatsen van alle bommen. Let op het volgende.
 * 1. Alleen gebruikte bommen mogen verder naar beneden vallen.
 * 2. Als een bom boven op de toren van de onderzeeer valt krijgt
 *    de speler een bonus.
 */

	int x, y, n_sub, n_bomb;

	for (n_bomb = 0; n_bomb < N_BOMB_MAX; n_bomb++) {
		/* verplaats de bommen */
		if (y_bomb[n_bomb] != 1) {	/* alleen gebruikte bommen */
			y = ++y_bomb[n_bomb];
			x = x_bomb[n_bomb];

			/* bom valt onder het scherm: geen hit */
			if (y > 24) {
				cursor(24, x);
				printf(" ");
				y_bomb[n_bomb] = 1;
				return;
			}
			/* veeg de oude bom uit */
			cursor(y - 1, x);
			printf(" ");

			/* druk de verplaatste bom af */
			cursor(y, x);
			printf("\255");

			/* controleer op een hit */
			for (n_sub = 0; n_sub < N_SUB_MAX; n_sub++)
				if (y_sub[n_sub] == y &&
				    x_sub[n_sub] <= x &&
				    x <= x_sub[n_sub] + 4) {
					/* raak!!!! */
					if (x_sub[n_sub] + 1 == x) {	/* op de toren */
						bonus_1(x_sub[n_sub], y_sub[n_sub], n_sub);
						bonus_2(x_sub[n_sub], y_sub[n_sub], n_sub);
						bonus_3(x_sub[n_sub], y_sub[n_sub], n_sub);
					}
					explode(x_sub[n_sub], y_sub[n_sub], n_sub);
					cursor(y - 1, x);
					printf(" ");
					y_bomb[n_bomb] = 1;
				}
		}
	}
}

/*************************************************************************/
bonus_1(x, y, n_sub)		/* deel 1 van bonus voor hit op de toren */
int x, y, n_sub;
{
/* Het laten zien van een bonus-explosie is in drie delen verdeeld
 * om te voorkomen, dat de post-optimizer van de Microsoft C compiler
 * de bonus functie te groot vindt.
 */

	int i;

	/* weg oude onderzeeer */
	/* klap 1 */
	cursor(y, x + 1);
	printf("%s\320%s", HI_VID, NM_VID);
	cursor(y - 1, x + 1);
	printf(" ");
	cursor(y - 2, x + 1);
	printf(" ");
	cursor(y - 3, x + 1);
	printf(" ");
	cursor(y - 4, x + 1);
	printf(" ");
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 2 */
	cursor(y, x + 1);
	printf("%s\372%s", HI_VID, NM_VID);
	cursor(y - 1, x + 1);
	printf("%s\265%s", HI_VID, NM_VID);
	cursor(y - 2, x + 1);
	printf(" ");
	cursor(y - 3, x + 1);
	printf(" ");
	cursor(y - 4, x + 1);
	printf(" ");
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 3 */
	cursor(y, x + 1);
	printf("%s\371%s", HI_VID, NM_VID);
	cursor(y - 1, x + 1);
	printf("%s\372%s", HI_VID, NM_VID);
	cursor(y - 2, x + 1);
	printf("%s\322%s", HI_VID, NM_VID);
	cursor(y - 3, x + 1);
	printf(" ");
	cursor(y - 4, x + 1);
	printf(" ");
	for (i = 0; i < 5000; i++);	/* delay */
}

/*************************************************************************/
bonus_2(x, y, n_sub)		/* deel 2 van bonus voor hit op de toren */
int x, y, n_sub;
{
	int i;

	/* klap 4 */
	cursor(y, x + 1);
	printf(" ");
	cursor(y - 1, x + 1);
	printf("%s\371%s", HI_VID, NM_VID);
	cursor(y - 2, x + 1);
	printf("%s\372%s", HI_VID, NM_VID);
	cursor(y - 3, x + 1);
	printf("%s\306%s", HI_VID, NM_VID);
	cursor(y - 4, x + 1);
	printf(" ");
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 5 */
	cursor(y, x + 1);
	printf(" ");
	cursor(y - 1, x + 1);
	printf(" ");
	cursor(y - 2, x + 1);
	printf("%s\371%s", HI_VID, NM_VID);
	cursor(y - 3, x + 1);
	printf("%s\372%s", HI_VID, NM_VID);
	cursor(y - 4, x + 1);
	printf("%s\320%s", HI_VID, NM_VID);
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 6 */
	cursor(y, x);
	printf("%s-S---%s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%s\371U o %s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("%s N\372 \370%s", HI_VID, NM_VID);
	cursor(y - 3, x);
	printf("%s\372O\370\372 %s", HI_VID, NM_VID);
	cursor(y - 4, x);
	printf("%s B   %s", HI_VID, NM_VID);
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 7 */
	cursor(y, x);
	printf("%s\371S--\371%s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%soU \370 %s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("%s\370N \371\370", HI_VID, NM_VID);
	cursor(y - 3, x);
	printf("%s Oo \370%s", HI_VID, NM_VID);
	cursor(y - 4, x);
	printf("%s\370B\371 \370%s", HI_VID, NM_VID);
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 8 */
	cursor(y, x);
	printf("%s-S-\370 %s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%s\372U\371 .%s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("%s N \372o%s", HI_VID, NM_VID);
	cursor(y - 3, x);
	printf("%s\370O \371 %s", HI_VID, NM_VID);
	cursor(y - 4, x);
	printf("%s B\371 \372%s", HI_VID, NM_VID);
	for (i = 0; i < 5000; i++);	/* delay */
}

/*************************************************************************/
bonus_3(x, y, n_sub)		/* deel 3 van bonus voor hit op de toren */
int x, y, n_sub;
{
	int i;

	/* klap 9 */
	cursor(y, x);
	printf("%s.S\371  %s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%s\370U\372  %s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("%s N\370 \372%s", HI_VID, NM_VID);
	cursor(y - 3, x);
	printf("%s\370O \372 %s", HI_VID, NM_VID);
	cursor(y - 4, x);
	printf("%s\372B . %s", HI_VID, NM_VID);
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 10 */
	cursor(y, x + 1);
	printf(" ");
	cursor(y - 1, x + 1);
	printf(" ");
	cursor(y - 2, x + 1);
	printf("%s\371%s", HI_VID, NM_VID);
	cursor(y - 3, x + 1);
	printf("%s\372%s", HI_VID, NM_VID);
	cursor(y - 4, x + 1);
	printf("%s\320%s", HI_VID, NM_VID);
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 11 */
	cursor(y, x + 1);
	printf(" ");
	cursor(y - 1, x + 1);
	printf("%s\371%s", HI_VID, NM_VID);
	cursor(y - 2, x + 1);
	printf("%s\372%s", HI_VID, NM_VID);
	cursor(y - 3, x + 1);
	printf("%s\306%s", HI_VID, NM_VID);
	cursor(y - 4, x + 1);
	printf(" ");
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 12 */
	cursor(y, x + 1);
	printf("%s\371%s", HI_VID, NM_VID);
	cursor(y - 1, x + 1);
	printf("%s\372%s", HI_VID, NM_VID);
	cursor(y - 2, x + 1);
	printf("%s\322%s", HI_VID, NM_VID);
	cursor(y - 3, x + 1);
	printf(" ");
	cursor(y - 4, x + 1);
	printf(" ");
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 13 */
	cursor(y, x + 1);
	printf("%s\372%s", HI_VID, NM_VID);
	cursor(y - 1, x + 1);
	printf("%s\265%s", HI_VID, NM_VID);
	cursor(y - 2, x + 1);
	printf(" ");
	cursor(y - 3, x + 1);
	printf(" ");
	cursor(y - 4, x + 1);
	printf(" ");
	for (i = 0; i < 5000; i++);	/* delay */

	/* klap 14, de laatste bonusklap */
	cursor(y, x + 1);
	printf("%s\320%s", HI_VID, NM_VID);
	cursor(y - 1, x + 1);
	printf(" ");
	cursor(y - 2, x + 1);
	printf(" ");
	cursor(y - 3, x + 1);
	printf(" ");
	cursor(y - 4, x + 1);
	printf(" ");

	/* bonus score */
	calc_score(15, 0);
}

/************************************************************************/
explode(x, y, n_sub)		/* onderzeeer n_sub is geraakt */
int x, y, n_sub;
{
	/* weg oude onderzeeer */
	/* klap 1, extra spatie om bom voor sub op te ruimen */
	cursor(y, x);
	printf("%s\260\261  \260%s ", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("");
	cursor(y - 2, x);
	printf("");
	cursor(y - 3, x);
	printf("");
	cursor(y - 4, x);
	printf("");

	/* klap 2 */
	cursor(y, x);
	printf("%sBOOM!%s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%s \260\261\260 %s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("");
	cursor(y - 3, x);
	printf("");
	cursor(y - 4, x);
	printf("");

	/* klap 3 */
	cursor(y, x);
	printf("%s\262\260 \260\262%s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%s\261\376\261\262\261%s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("%s \262\260\262\261%s", HI_VID, NM_VID);
	cursor(y - 3, x);
	printf("%s  \260\376\260 %s", HI_VID, NM_VID);
	cursor(y - 4, x);
	printf("%s  \260  %s", HI_VID, NM_VID);

	/* klap 4 */
	cursor(y, x);
	printf("%s\376   \376%s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%sboom!%s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("%s\260\261\262\261\260%s", HI_VID, NM_VID);
	cursor(y - 3, x);
	printf("%s\261\333\262\333\261%s", HI_VID, NM_VID);
	cursor(y - 4, x);
	printf("%s \260\376\260 %s", HI_VID, NM_VID);

	/* klap 5 */
	cursor(y, x);
	printf("%s \337  \334%s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%sBOOM!%s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("%s\336\260 \333\261%s", HI_VID, NM_VID);
	cursor(y - 3, x);
	printf("%s \262\333 \260%s", HI_VID, NM_VID);
	cursor(y - 4, x);
	printf("%s\260  \334 %s", HI_VID, NM_VID);

	/* klap 6 */
	cursor(y, x);
	printf("%s\260    %s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%sB00M!%s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("%s\260\260  \260%s", HI_VID, NM_VID);
	cursor(y - 3, x);
	printf("%s \376 \262 %s", HI_VID, NM_VID);
	cursor(y - 4, x);
	printf("%s  \376  %s", HI_VID, NM_VID);

	/* klap 7 */
	cursor(y, x);
	printf("%s   \376 %s", HI_VID, NM_VID);
	cursor(y - 1, x);
	printf("%s\261ooM\376%s", HI_VID, NM_VID);
	cursor(y - 2, x);
	printf("%s \376   %s", HI_VID, NM_VID);
	cursor(y - 3, x);
	printf("%s \260 \376 %s", HI_VID, NM_VID);
	cursor(y - 4, x);
	printf("%s  \376  %s", HI_VID, NM_VID);

	/* klap 8, de laatste alles uitvegen */
	cursor(y, x);
	printf("     ");
	cursor(y - 1, x);
	printf("     ");
	cursor(y - 2, x);
	printf("     ");
	cursor(y - 3, x);
	printf("     ");
	cursor(y - 4, x);
	printf("     ");

	/* plaats onderzeeer ergens anders */
	x_sub[n_sub] = rand() % 70 + 2;
	y_sub[n_sub] = rand() % 20 + 5;

	/* nieuwe score */
	calc_score(y, 0);
}

/*************************************************************************/
drop_bomb()				/* drop bombs */
{
	int n_bomb = 0; 

	/* only on a keyboard hit, drop a bomb */
	if (readch() == -1) return;

	/* find a free bomb */
	while (n_bomb < N_BOMB_MAX && y_bomb[n_bomb] != 1)
		n_bomb++;

	/* drop it */
	if (n_bomb < N_BOMB_MAX) {
		x_bomb[n_bomb] = x_ship + 1;
		y_bomb[n_bomb] = 2;
		cursor(2, x_ship + 1);
		printf("\255");
	}
}

/*************************************************************************/
print_score()					/* print the scoring list */
{
/* returns TRUE if another game should be played, and FALSE if not */

	FILE *score_file;
	int n_player, new_player, new_score, i;
	char *old_name, *new_name, answer;

	struct score_list {
		int score;
		char name[16];
	} list[20];

	/* raw mode, blocked read, cursor off */
	fcntl(0, F_SETFL, O_ACCMODE);

	/* open the score_file */
	printf(CLRSRCN);
	if ((score_file = fopen(SCOREFILE, "r")) == NULL) {
		cursor(22, 1);
		printf("diepbom: file %s%s%s cannot be opened for reading\r\n", 
			HI_VID, SCOREFILE, NM_VID);
		printf("Do you want to play again? Type in y or n: %sn%s\b", HI_VID, NM_VID);
		answer = readch();
		fcntl(0, F_SETFL, O_NONBLOCK);		
		return (answer == 'y') ? TRUE : FALSE;
	}

	/* read the score file, assuming it to be properly dimensioned */
	for (n_player = 0; n_player < 20; n_player++) {
		fscanf(score_file, "%d", &(list[n_player].score));
		new_name = list[n_player].name;
		getc(score_file); /* eat the space */
		while ((*new_name = getc(score_file)) != '\n') new_name++;
		*new_name = (char) NULL;
	}

	fclose(score_file);

	/* make a new list of the scores */
	if ((new_score = calc_score(-1, 0)) > list[19].score) {

		/* bepaal rangnummer van nieuwe score */
		n_player = 0;
		while (n_player < 19 && new_score < list[n_player].score)
			n_player++;
		new_player = n_player;
		printf("You have gained %d points, so you're number %d\r\n", 
			new_score, new_player + 1);

		/* verplaats de lagere spelers */
		for (n_player = 19; n_player > new_player; n_player--) {
			list[n_player].score = list[n_player - 1].score;
			new_name = list[n_player].name;
			old_name = list[n_player - 1].name;
			while (*new_name++ = *old_name++);
		}
		
		/* de nieuwe entry */ 
		list[new_player].score = new_score;
		if (*db_expert) {
			strncpy(list[new_player].name, db_expert, 16);
		} else {
			/* cooked mode, blocked, cursor on */
			ioctl(0, TIOCSETP, &original_tty);
			printf(CURSOR_ON);
			printf("Please give your name for the score list: ");
			printf("\"               \"");
			printf("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");
			new_name = list[new_player].name;
			while (new_name-list[new_player].name < 16 && 
						(*new_name = getchar()) != '\n') 
				switch(*new_name) {
				case '\b': new_name--; break;
				default  : new_name++; break;
			}
			*new_name = (char) NULL;
			/* raw mode, blocked, cursor off */
			ioctl(0, TIOCSETP, &raw_tty);
			printf(CURSOR_OFF);
		}

		/* write the new file to disk */
		if ((score_file = fopen(SCOREFILE, "w")) != NULL) {
			for (n_player = 0; n_player < 20; n_player++)
				fprintf(score_file, "%d %s\n", list[n_player].score, list[n_player].name);
			fclose(score_file);
		} else {
			cursor(22, 1);
			printf("diepbom: file %s%s%s cannot be opened for writing\r\n", 
				HI_VID, SCOREFILE, NM_VID);
			printf("press any key to continue");
			readch();
		}
	} else {
		printf("You have gained %d points, which is not enough to be listed \r\n", new_score);
	}

	/* show the scores */
	cursor(4, 20);
	printf("Scores of %s*** Diepbom ***%s\r\n\r\n", HI_VID, NM_VID);
	for (n_player = 0; n_player < 10; n_player++)
		printf("    %3d %s%5d%s %-16s         %3d %s%5d%s %-16s\r\n",
			n_player + 1, HI_VID, list[n_player].score, NM_VID,
			list[n_player].name, n_player + 11, HI_VID,
			list[n_player + 10].score, NM_VID, list[n_player + 10].name);

	/* Wacht tot men is uitgekeken, en einde */
	cursor(23, 1);
	printf("Do you want to play again? Type in y or n: %sn%s\b",  HI_VID, NM_VID);
	answer = readch();
	fcntl(0, F_SETFL, O_NONBLOCK);		
	return (answer == 'y') ? TRUE : FALSE;
}

/*************************************************************************/
clean_up()			/* clean up the final bits'n'pieces */
{
	/* terminal back to normal */
	exit_terminal();

	/* word of thanks */
	cursor(23, 1);
	printf("Thank you for playing *** Diepbom ***\n");

	exit(0);
}

/**************************************************************************/
readch()				/* read a character in raw mode */
{
	register int result;
	char ch;

	result = read(0, &ch, 1);
	if (result == -1) /* Non-blocked read */
		return result;
	return ch & 0x7F;
}
