/* file: uux.c
** author: Peter S. Housel (housel@ecn.purdue.edu)
*/

/* This entire program is a quick, ugly hack. Sloppiness abounds. There isn't
** much error checking. I'm ashamed of it.
** However, it does handle the restricted cases that it needs to - 
** in particular running remote rmail and remote rnews. As long as you're
** gentle with it.
*/

#include <stdio.h>
#include <pwd.h>
#include <ctype.h>

/* from dcp.h - move out eventually */
#define NODENAME	"/etc/uucpname"
#define LSYS		"/usr/lib/uucp/L.sys"
#define SPOOLDIR	"/usr/spool/uucp"
#define SPOOLSEQ	"/usr/lib/uucp/SPOOLSEQ"
#define LSPOOLSEQ	"/usr/lib/uucp/SPOOLSEQ.lock"
#define CICO		"/usr/lib/uucp/uucico"

#define SITENAMELEN	32	/* max length of sitename */
#define DEFGRADE	'a'	/* or whatever */

extern int getopt();
extern int optind;
extern char *optarg;
extern char *index(/* char *string, char c */);
extern char *rindex(/* char *string, char c */);
extern char *mktemp(/* char *template */);
extern FILE *fopen();
extern struct passwd *getpwuid();

void usage(), dostdin(), doarg();
char *uucpname(), *whoami();
char *filesite(/* char *filename */), *filepath(/* char *filename */);
char *basename(/* char *filename */);
int getseq();

char tempname[] = "/usr/spool/uucp/TM.XXXXXX";
char luser[16];			/* local user name */
char mysite[SITENAMELEN];	/* this host's uucpname */
char cmdsite[SITENAMELEN];	/* site where command is run */
char cmd[64];			/* remote command name */
char arglist[2048] = "";	/* remote argument list */
FILE *commandfile;		/* the "C." spool command file */
FILE *execfile;			/* the "X." remote spool execute file */
char grade = DEFGRADE;		/* transfer grade */
int nocico = 0;			/* "don't run uucico" flag */
int trylink = 0;		/* try spoolfile links before copying */
int readstdin = 0;		/* read standard input ("-" or "-p") */

main(argc, argv)
int argc; char *argv[];
{
 int c;				/* option character */
 int seq;			/* 'seq number' of X. file */
 char scratch[256];		/* ubiquitous scratch buffer */
 char *p;			/* equally ubiquitous scratch pointer */
 
 strcpy(mysite, uucpname());
 if(strlen(mysite) == 0)
   {
    fprintf(stderr, "uux: can't get my own uucpname\n");
    exit(1);
   }
 strcpy(luser, whoami());

 while((c = getopt(argc, argv, "lprva:g:")) != EOF)
      {
       switch(c)
	     {
	      case 'r':
			nocico = 1;
			break;

	      case 'g':
			if(isalnum(optarg[0]) && '\0' == optarg[1])
			  grade = optarg[0];
			else
			  fprintf(stderr, "uux: %s: illegal grade\n", optarg);
			break;

	      case 'l':
			trylink = 1;
			break;

	      case 'p':
			readstdin = 1;
			break;

	      case 'a':
			break;

	      default:
			usage();
			exit(1);
	     }
      }

 if(optind < argc && strcmp(argv[optind], "-") == 0)
   {
    ++optind;
    readstdin = 1;
   }

 if(optind >= argc)
   {
    usage();
    exit(1);
   }
 
 if(NULL == (p = filesite(argv[optind])))
   {
    fprintf(stderr, "uux: illegal command\n");
    exit(1);
   }
 strcpy(cmdsite, p);
 if(NULL == (p = filepath(argv[optind])))
   {
    fprintf(stderr, "uux: illegal command\n");
    exit(1);
   }
 strcpy(cmd, p);
 ++optind;

 if(strlen(cmdsite) == 0)
   {
    fprintf(stderr, "uux: local commands not implemented yet\n");
    exit(1);
   }
 else if(!knowhost(cmdsite))
   {
    fprintf(stderr, "uux: site %s unknown\n", cmdsite);
    exit(1);
   }

 if(NULL == (commandfile = fopen(mktemp(tempname), "w")))
   {
    fprintf(stderr, "uux: can't open ");
    perror(tempname);
    exit(1);
   }
 
 seq = getseq();
 sprintf(scratch, "%s/D.%s%c%04d", SPOOLDIR, mysite, 'X', seq);
 if(NULL == (execfile = fopen(scratch, "w")))
   {
    fprintf(stderr, "uux: can't open ");
    perror(scratch);
    exit(1);
   }
 fprintf(commandfile, "S D.%s%c%04d X.%s%c%04d %s - D.%s%c%04d 0666\n",
		      mysite, 'X', seq, mysite, 'X', seq, luser,
		      mysite, 'X', seq);

 fprintf(execfile, "U %s %s\nR %s\n", luser, mysite, luser);

 if(readstdin)
    dostdin();

 while(optind < argc)
       doarg(argv[optind++]);

 fprintf(execfile, "C %s %s\n", cmd, arglist);
 fclose(execfile);
 fclose(commandfile);
 sprintf(scratch, "%s/C.%s%c%04d", SPOOLDIR, cmdsite, grade, seq);
 if(link(tempname, scratch) == 0)
    unlink(tempname);
 else
   {
    fprintf(stderr, "uux: couldn't rename commandfile");
    exit(1);
   }

 if(nocico)
    exit(0);
 else
    execl(CICO, "-r1", (char *)NULL);
}

void usage()
{
 fprintf(stderr, "usage: uux [-plrv] [-g grade] [-a user] [-] host!cmd arg ...\n");
}

void dostdin()
{
 char name[128], spoolname[128];	/* spool data filename */
 FILE *data;				/* spool data file */
 int seq;				/* spool sequence number */
 int c;					/* char from stdin */

 seq = getseq();
 sprintf(name, "D.%s%c%04d", mysite, grade, seq);
 sprintf(spoolname, "%s/%s", SPOOLDIR, name);
 if(NULL == (data = fopen(spoolname, "w")))
   {
    fprintf(stderr, "uux: can't copy stdin\n");
    return;
   }
 while(EOF != (c = getc(stdin)))
       putc(c, data);
 fclose(data);

 fprintf(execfile, "F %s\nI %s\n", name, name);
 fprintf(commandfile, "S %s %s %s - %s 0666\n", name, name, luser, name);
}

void doarg(arg)
char *arg;
{
 char name[128], spoolname[128];	/* spool data filename */
 FILE *data;				/* spool data file */
 FILE *source;				/* source data file */
 int seq;				/* spool sequence number */
 int c;					/* char from input */

 if('(' == arg[0] && ')' == arg[strlen(arg) - 1])
   {
    strcat(arglist, arg + 1);
    arglist[strlen(arglist) - 1] = '\0';
   }
 else if(NULL == index(arg, '!'))
    strcat(arglist, arg);
 else if(strcmp(filesite(arg), cmdsite) == 0)
   {
    strcat(arglist, filepath(arg));
   }
 else if(strlen(filesite(arg)) == 0)
   {
    seq = getseq();
    sprintf(name, "D.%s%c%04d", mysite, grade, seq);
    sprintf(spoolname, "%s/%s", SPOOLDIR, name);

    if(!trylink || link(filepath(arg), spoolname) < 0)
      {
       if(NULL == (data = fopen(spoolname, "w"))
	  || NULL == (source = fopen(filepath(arg), "r")))
	 {
	  fprintf(stderr, "uux: can't copy %s to spool directory",
		  filepath(arg));
	  exit(1);
	 }
       while(EOF != (c = getc(source)))
	     putc(c, data);
       fclose(data);
       fclose(source);
      }
    fprintf(commandfile, "S %s %s %s - %s 0666\n", filepath(arg), name,
	    luser, name);
    fprintf(execfile, "F %s %s\n", name, basename(filepath(arg)));
    strcat(arglist, basename(filepath(arg)));
   }
 else
   {
    fprintf(stderr, "uux: illegal argument %s\n", arg);
    return;
   }

 strcat(arglist, " ");
}
  
/*
 * |uucpname()| returns a pointer to the local host's UUCP nodename.
 * There are several possible means of determining this, depending
 * on the operating system version. For now, this version just reads
 * one line from the |NODENAME| file, which is usually either "/etc/cpu"
 * or "/etc/uucpname".
 */
char *uucpname()
{
 FILE *uufile;
 static char uuname[SITENAMELEN];

 if(NULL == (uufile = fopen(NODENAME, "r")))
    return "";
 fgets(uuname, sizeof uuname, uufile);
 uuname[strlen(uuname) - 1] = '\0';	/* remove '\n' */
 fclose(uufile);

 return uuname;
}

int knowhost(host)
char *host;
{
 FILE *sysfile;
 char line[256];
 char *p, *q;

 if(NULL == (sysfile = fopen(LSYS, "r")))
    return 0;
 while(fgets(line, sizeof line, sysfile) != NULL)
      {
       for(p = host, q = line; !isspace(*q); p++, q++)
           if(*p != *q)
              break;
       if('\0' == *p && isspace(*q))
         {
          fclose(sysfile);
          return 1;
         }
      }
 fclose(sysfile);
 return 0;
}

int getseq()
{
 int i = 0;
 char seqline[10];
 FILE *spoolseq;

 if(access(SPOOLSEQ, 0) != 0)
    close(creat(SPOOLSEQ, 0600));

 while(link(SPOOLSEQ, LSPOOLSEQ) != 0)
      {
       sleep(5);
       if(++i > 5)
         {
          fprintf(stderr, "uux: can't lock %s\n", SPOOLSEQ);
	  exit(1);
         }
      }

 spoolseq = fopen(SPOOLSEQ, "r");
 fgets(seqline, sizeof seqline, spoolseq);
 fclose(spoolseq);
 unlink(LSPOOLSEQ);

 i = (atoi(seqline) + 1) % 1000;

 if(NULL == (spoolseq = fopen(SPOOLSEQ, "w")))
   {
    fprintf(stderr, "uux: can't write %s\n", SPOOLSEQ);
    exit(1);
   }
 fprintf(spoolseq, "%d\n", i);
 fclose(spoolseq);

 return i;
}

char *whoami()
{
 struct passwd *pw;

 if(NULL != (pw = getpwuid(getuid())))
    return pw->pw_name;
 else
    return "nobody";
}

char *filesite(name)
char *name;
{
 static char site[SITENAMELEN];
 char *p;
 char *q;

 if(NULL == (p = index(name, '!')))
    return NULL;

 q = site;
 while(name < p)
       *q++ = *name++;
 *q = '\0';

 return site;
}

char *filepath(name)
char *name;
{
 char *p;

 if(NULL == (p = rindex(name, '!')))
    return NULL;

 return p + 1;
}

char *basename(name)
char *name;
{
 char *p;

 if(NULL == (p = rindex(name, '/')))
    return name;
 else
    return p + 1;
}
