/*
 * dcpxfer.c 
 *
 * Revised edition of dcp 
 *
 * Stuart Lynne May/87 
 *
 * Copyright (c) Richard H. Lamb 1985, 1986, 1987 Changes Copyright (c) Stuart
 * Lynne 1987 
 *
 * "DCP" a uucp clone. Copyright Richard H. Lamb 1985,1986,1987
 * file send routines
 */
#include "dcp.h"
#include <ctype.h>

extern int errno;
extern char *sys_errlist[];

static unsigned char rpacket[MAXPACK];
static unsigned char spacket[MAXPACK];

/***************SEND PROTOCOL****************/

/*
 * s d a t a 
 *
 * Send File Data 
 */
sdata()
{
 while(TRUE)
      {
       if((size = fread(spacket, 1, pktsize, fp)) <= 0) /* Get data */
	  return ('Z');		/* If EOF set state to that */
       if((*sendpkt) (spacket, size, 0))
	  return (0);		/* send data */
      }

 return ('D');		/* sent data, stay in state D */
}


/*
 * s b r e a k 
 *
 */
sbreak()
{
 int len, i;

 if(sendmsg("H") < 0)
    return (0);
 if(getmsg(spacket) < 0)
    return 0;
 printmsg(M_CONVERSE, "Switch modes: %s", spacket);
 if(spacket[1] == 'N')
    return ('G');
 return ('Y');
}


/*
 * s e o f 
 *
 * Send End-Of-File. 
 */
seof()
{
 int len, i;

 fclose(fp);
 fp = NULL;

 if((*sendpkt) (spacket, 0, 0) < 0)	/* length zero packet indicates EOF */
    return (0);
 if(getmsg(spacket) < 0)
    return (0);		/* receive CY or CN */
 if(strncmp(spacket, "CY", 2))
    return (0);		/* couldn't send file */

 unlink(fromfile);
 printmsg(M_TRANSFER, "Transfer of %s completed.", fromfile);

 /*
  * fprintf( syslog, "%s!%s (%d/%d-%d:%d:%d) -> %ld / %ld secs", host, id,
  * size, secs ); 
  */

 return ('F');		/* go get the next file to send */
}

/*
 * s f i l e 
 *
 * Send File Header. 
 */
sfile()
{
 int i, len;
 char *cp;

 if(fp == NULL)
   {				/* If not already open, */
    printmsg(M_SPOOL, "looking for next file...");
    if(getfile())
      {				/* get next file from current work */
       fclose(fw);
       unlink(cfile);		/* close and delete completed workfile */
       fw = NULL;
       return ('B');		/* end sending session */
      }


    printmsg(M_SPOOL, "Opening %s for sending.", fromfile);
    fp = fopen(fromfile, "r");	/* open the file to be sent */
    if(fp == NULL)
      {				/* If bad file pointer, give up */
       printmsg(M_ERROR, "Cannot open file %s.", fromfile);
       return ('A');
      }
   }
 else
   return ('A');	/* If something's already open, we're in trouble */
 printmsg(M_SPOOL, "Sending %s as %s", fromfile, tofile);
 if(sendmsg(tofile) < 0)
    return (0);		/* send 'S fromfile tofile user - tofile 0666'. */
 if(getmsg(spacket) < 0)
   return (0);
 if (spacket[1] != 'Y')
    return ('A');		/* If otherside says no-quit */
 return ('D');
}

/*
 * s i n i t 
 *
 * Send Initiate: send this host's parameters and get other side's back. 
 */
sinit()
{
 if((*openpk) ())
    return ('A');
 return ('B');
}


/* 
 *
 * getfile 
 *
 * getfile reads the next line from the presently open workfile (cfile) and
 * determines from this the next file to be sent (file). If there are no more
 * TRUE is returned. A fix for "R from to 0666" should be done here to
 * recieve files in addition to sending them. The appropriate "state
 * letter" i.e. "R" should be returned to the send "master" or "slave"
 * state switching table in "dcp.c" I did not implement this since the
 * majority of uucp transactions appear to be "S from to 0666" type.
 * RHLamb 1/87 
 */
getfile()
{
 int i;
 char line[132], buf[132];
 register char *cp;
 
 if(fgets(line, BUFSIZ, fw) == (char *) NULL)
    return (TRUE);

 sscanf(line, "%*c %*s %*s %*s %*s %s", buf);
 sprintf(fromfile, "%s/%s", SPOOLDIR, buf);

 for(i = 0, cp = line; *cp != '\0'; i++, cp++)
    {
     if(strncmp(cp, "0666", 4) == 0)
        break;
    }
 cp += 4;
 *cp = '\0';
 strcpy(tofile, line);
 printmsg(M_SPOOL, "getfile: fromfile=%s, tofile=%s.", fromfile, tofile);
 return (FALSE);
}


/*********************** MISC SUB SUB PROTOCOL *************************/

/*
 *
 * schkdir
 * scan the dir 
 */
schkdir()
{
 char c;

 c = scandir();
 if(c == 'Q')
   {
    return ('Y');
   }
 if (c == 'S')
   {
    sprintf(rpacket, "HN");
    if((*sendpkt) (rpacket, 0, 1))
      return (0);
   }
 return ('B');
}

/* 
 * endp() end protocol 
 *
 */
endp()
{
 (void) sendmsg("HY");
 (*closepk) ();
 return ('P');
}



/***********************RECIEVE PROTOCOL**********************/

/*
 * r d a t a 
 *
 * Receive Data 
 */
rdata()
{
 int len;
 
 if ((*getpkt) (rpacket, &len))
    return (0);

 if(len == 0)
   {
    fclose(fp);
    /* we ought to do the copy in a temp file, and move it here */
    if(sendmsg("CY") < 0)
      return (0);
    printmsg(M_TRANSFER, "transfer complete");
    return ('F');
   }

 if(fwrite(rpacket, len, 1, fp) != 1)	/* Write the data to the file */
    return (0);
 return ('D');			/* Remain in data state */
}


/*
 * r f i l e 
 *
 * Receive File Header 
 */
rfile()
{
 char buf[256];
 char *flds[10];
 int numflds;
 
 int len, i;
 char tmpfilename[256];	/* Holds the converted file name */
 char *cp;
 
 printmsg(M_TRANSFER, "rfile entered");
 
 if(getmsg(buf) < 0)
    return 0;

 if(buf[0] == 'H')
    return ('C');

 printmsg(M_TRANSFER, "rfile: buf %d \"%s\"", len, buf);

 /*
  * Convert upper case to lower
  * for(cp = buf; *cp != '\0';cp++)
  *     if(isupper(*cp))
  *	   tolower(*cp); 
  */

 numflds = getargs(buf, flds);

 cp = flds[2];
 printmsg(M_INFO, "rfile: receive file \"%s\"", cp);

 /* check for ~/ destination -> /usr/spool/uucppublic */
 if (strncmp(cp, "~/", 2) == SAME)
   sprintf(tmpfilename, "%s%s", PUBDIR, cp + 1);
 else
   sprintf(tmpfilename, "%s/%s", SPOOLDIR, cp);
 printmsg(M_INFO, "rfile: receive file \"%s\"", tmpfilename);

 /* check for dirname only */
 cp = tmpfilename + strlen(tmpfilename) - 1;
 if (*cp == '\n')
   *cp-- = '\0';
 
 if(*cp == '/')
   {
    cp = rindex(flds[1], '/');
    if(cp == (char *) NULL)
       cp = flds[1];
    else
       cp++;

    strcat(tmpfilename, cp);
   }

 strcpy(tofile, tmpfilename);
 printmsg(M_TRANSFER, "rfile: receive file \"%s\"", tofile);

 if((fp = fopen(tofile, "w")) == NULL)
   {				/* Try to open a new file */
    printmsg(M_ERROR, "cannot create %s err=%s", tofile, sys_errlist[errno]);
    return ('A');	/* Give up if can't */
   }
 printmsg(M_TRANSFER, "Receiving %s as %s", flds[1], tofile);
  if(sendmsg("SY") < 0)
   return (0);
 return ('D');		/* Switch to data state */
}

/*
 * r i n i t 
 *
 * Receive Initialization 
 */
rinit()
{
 if ((*openpk) ())
   return (0);
 return ('F');
}


/*
 * |getmsg()| recieves a null-terminated "conversation-level" message
 * from the communications channel. This may require one or more packets,
 * but all of them will be "long-data" packets containing a full 64 bytes.
 */
int getmsg(dest)
char *dest;
{
 int len;

 while(1)
      {
       if((*getpkt)(dest, &len) < 0)
          return -1;
       *(dest + len) = '\0';		/* make sure it's terminated */
       if(strlen(dest) != len)
	  break;			/* we reached the terminator */
       dest += len;
      }

 return 0;
}

/*
 * |sendmsg(message)| sends a null-terminated "conversation-level" message.
 */
int sendmsg(message)
char *message;
{
 int len;
 len = strlen(message) + 1;		/* total length including '\0' */

 while(1)
      {
       if((*sendpkt)(message, 0, 1) < 0) /* send with padding */
          return -1;
       if((len -= pktsize) <= 0)
          break;
       message += pktsize;
      }
 return 0;
}
