/*
 * dcpunix.c - Unix/Minix support for dcp
 * Peter S. Housel
 */

#include <stdio.h>
#include <ctype.h>
#include <sgtty.h>
#include <dial.h>
#include <signal.h>
#include "dcp.h"

extern char *_merr_list[];
extern int merrno;

int timedout;		/* set when alarm goes off */
int swritefd;		/* fd for serial write */
int sreadfd;		/* fd for serial read */
CALL call;		/* dial(3) structure */

int ontime()
{
 signal(SIGALRM, ontime);
 timedout = 1;
 return 0;
}

swrite(data, num)
char *data; int num;
{
 return write(swritefd, data, num);
}

int sread(data, num, timeout)
char *data; int num, timeout;
{
 int ret;

 if(timeout)
    alarm(timeout);
 else
    alarm(2);
 signal(SIGALRM, ontime);

 ret = read(sreadfd, data, num);
 alarm(0);
 if(ret < 0)
    return 0;
 return ret;
}

int sread2(data, num)
char *data; int num;
{
 return read(sreadfd, data, num);
}

shell(command, inname, outname, errname)
char *command;
char *inname;
char *outname;
char *errname;
{
 int waitstat;
 int fd;

 printmsg(M_INFO, "shell: %s < %s > %s", command, inname, outname);

 if(strncmp(command, "rmail", 5) != 0 && strncmp(command, "rnews", 5) != 0)
   {
    printmsg(M_ERROR, "illegal command \"%s\"", command);
    return;
   }

 switch(fork())
       {
	case -1:
		printmsg(M_ERROR, "couldn't fork");
		return;
	case 0:
		if(strlen(inname) != 0)
		  {
		   fd = open(inname, 0);
		   dup2(fd, 0);
		   if(fd > 0)
		      close(fd);
		   printmsg(M_INFO, "Changed infile to %s, fd=%d", inname, fd);
		  }
		if(strlen(outname) != 0)
		  {
		   fd = creat(outname, 0644);
		   dup2(fd, 1);
		   if(fd > 1)
		      close(fd);
		  }
		execl("/bin/sh", "sh", "-c", command, (char *)0);
		printmsg(M_ERROR, "couldn't exec shell");
		exit(1);
	default:
		wait(&waitstat);
		if(waitstat != 0)
		   printmsg(M_ERROR, "xqt status of 0x%x for command \"%s\"",
			    command);
       }
}

int initline()
{
 struct sgttyb ttyb;

 sreadfd = 0;	/* standard input */
 swritefd = 1;	/* standard output */

 gtty(sreadfd, &ttyb);	/* set raw mode */
 ttyb.sg_flags |= RAW;
 ttyb.sg_flags &= ~(XTABS | EVENP | ODDP | CRMOD | ECHO | CBREAK);
 stty(sreadfd, &ttyb);

 return 0;
}


int dcpdial(dev, speed, tel)
char *dev, *speed, *tel;
{
 call.baud = call.speed = atoi(speed);
 call.line = dev;
 call.telno = tel;
 call.modem = 0;

 printmsg(M_CALL, "Dialing at speed %d", call.speed);
 if(tel != NULL)
    printmsg(M_CALL, "Calling phone# %s", call.telno);
 if((sreadfd = swritefd = dial(&call)) < 0)
   {
    printmsg(M_ERROR, "dial failed, merror=%s (%d)",
	     _merr_list[-merrno], merrno);
    return FALSE;
   }

 return TRUE;
}

dcpundial()
{
 if(swritefd > 2)
    hangup(swritefd);
}
