/*
 * dcpsys.c Revised edition of dcp Stuart Lynne May/87 Copyright (c) Richard
 * H. Lamb 1985, 1986, 1987 Changes Copyright (c) Stuart Lynne 1987 
 *
 * "DCP" a uucp clone. Copyright Richard H. Lamb 1985,1986,1987
 */

/* Get the next system, and other support routines  */

#include <sys/types.h>
#ifdef BSD
#include <sys/dir.h>
#else
#include <dirent.h>
#define direct dirent
#endif

#include "dcp.h"
#define PROTOS  "g"
#define MAXLOGTRY       3

Proto Protolst[] =
{
   'g', ggetpkt, gsendpkt, gopenpk, gclosepk,
/*
 * 'k', kgetpkt, ksendpkt, kopenpk, kclosepk,
 * 'r', rgetpkt, rsendpkt, ropenpk, rclosepk,
 * 't', tgetpkt, tsendpkt, topenpk, tclosepk, 
 */
   '0',
};

#define EOTMSG "\004\r\004\r"

procref getpkt, sendpkt, openpk, closepk;

char device[32];
char speed[10];

/*
 *            Sub Systems
 *
 * getsystem
 * Process an "L.sys" file entry
 */
getsystem()
{
 int i;

 if(fgets(sysline, BUFSIZ, fsys) == (char *) NULL)
   return ('A');
 printmsg(M_INFO, "%s", sysline);

 kflds = getargs(sysline, flds);
 strcpy(rmtname, flds[FLD_REMOTE]);
 cctime = flds[FLD_CCTIME];
 strcpy(device, flds[FLD_DEVICE]);
 strcpy(speed, flds[FLD_SPEED]);
 
 if(debuglevel >= M_INFO)
   for(i = FLD_EXPECT; i < kflds; i += 2)
     fprintf(stderr, "expect[%02d]:\t%s\nsend  [%02d]:\t%s\n",
	             i, flds[i], i + 1, flds[i + 1]);

 printmsg(M_INFO, "rmt=%s ctm=%s", rmtname, flds[FLD_CCTIME]);
 printmsg(M_INFO, "dev=%s spd=%s tel=%s ", device, speed, flds[FLD_PHONE]);

 fw = (FILE *) NULL;
 if(/* (checktime( cctime )) || */
    (strcmp(Rmtname, "all") == SAME) ||
    (strcmp(Rmtname, rmtname) == SAME) ||
    ((strcmp(Rmtname, "any") == SAME) && scandir() == 'S'))
   {
    if (fw != (FILE *) NULL)
      fclose(fw);		/* in case we matched with scandir */
    return ('S');		/* startup this system */
   }
 else
   return ('G');
}


/*
 *
 * checkname
 * Do we know the guy ? 
 */
checkname(name)
char name[];
{
 FILE *ff;
 char line[BUFSIZ], tmp[20];	/* can change to 8 if %8s works */
 
 if ((ff = fopen(LSYS, "r")) == NULL)
   return (FAILED);
 
 while (fgets(line, BUFSIZ, ff) != (char *) NULL)
   {
    sscanf(line, "%8s ", tmp);
    printmsg(M_INFO, "rmt= '%s' sys= '%s'", name, tmp);
    if(strncmp(tmp, name, 7) == 0)
      {
       fclose(ff);
       return (OK);		/* OK I like you */
      }
   }
 fclose(ff);
 return (FAILED);		/* Who are you ? */
}

/*
 *
 * checktime
 * check if we may make a call at this time
 */
checktime(xtime)
char xtime[];
{
 return (0);			/* OK go to it */
}

/*
 * sysend
 * end UUCP session negotiation 
 */
sysend()
{
 char msg[80];

 msg[1] = '\0';
 msgtime = 2 * MSGTIME;
 /* while (msg[1] != 'O') { */
 wmsg("OOOOOO", 2);
 if(rmsg(msg, 2) == -1)
   goto hang;
 /* } */
hang:
 wmsg("OOOOOO", 2);
 dcpundial();
 if(remote == MASTER)
   return ('I');
 return ('A');
}

/*
 *
 * wmsg
 * write a ^P type msg to the remote uucp 
 */
wmsg(msg, syn)
int syn;
char msg[];
{
 int len;

 printmsg(M_CALL, "wmsg %s", msg);

 len = strlen(msg);
 if(syn == 2)
   swrite("\0\020", 2);
 swrite(msg, len);
 if(syn == 2)
   swrite("\0", 1);
}

/*
 * rmsg
 * read a ^P msg from UUCP 
 */
rmsg(msg, syn)
int syn;
char msg[];
{
 int ii;
 char c, cc[5];

 c = 'a';
 if(syn == 2)
   {
    while( c != 0x10 )
         {
	  if(sread(cc, 1, msgtime) < 1)
	    return (-1);
	  c = cc[0] & 0x7f;	/* Dont ask. MSC needs more than a byte to
				 * breathe */
	 }
   }

 for (ii = 0; ii < 132 && c; ii++)
   {
    if (sread(cc, 1, msgtime) < 1)
      return (-1);
    c = cc[0] & 0x7f;
    if(c == '\r' || c == '\n')
      c = '\0';
    msg[ii] = c;
   }
 return (strlen(msg));
}

/*
 *
 * startup
 */
startup()
{
 char msg[80], tmp1[20], tmp2[20];
 int i;
 char pro;

 if(remote == MASTER)
   {
    msgtime = 2 * MSGTIME;
    if (rmsg(msg, 2) == -1)
      return ('Y');
    printmsg(M_CALL, "1st msg = %s", msg);
    if(msg[5] == '=' && strncmp(&msg[6], rmtname, 7))
      return ('Y');

    sprintf(msg, "S%.7s -Q0 -x%d", nodename, debuglevel);
    /* -Q0 -x16 remote debuglevel set */
    /* sprintf(msg, "S%.7s", nodename); */
    printmsg(M_CALL, "Reply to 1st msg = %s", msg);
    wmsg(msg, 2);

    if(rmsg(msg, 2) == -1)
      return ('Y');
    printmsg(M_CALL, "2nd msg = %s", msg);
    if(strncmp(&msg[1], "OK", 2))
      return ('Y');

    if (rmsg(msg, 2) == -1)
      return ('Y');
    printmsg(M_CALL, "3rd msg = %s", msg);

    for(i = 0; (pro = PROTOS[i]), pro; ++i)
        if(msg[0] == 'P' && index(&msg[1], pro) != NULL)
	  {
	   sprintf(msg, "U%c", pro);
	   printmsg(M_CALL, "Reply to 3rd msg = %s", msg);
	   wmsg(msg, 2);
	   setproto(pro);
	   return ('D');
	  }
    printmsg(M_ERROR, "Replying 'UN' - no common protocol");
    wmsg("UN", 2);
    return ('Y');
   }
 else	/* slave */
   {
    msgtime = 2 * MSGTIME;
    sprintf(msg, "Shere=%s", nodename);
    wmsg(msg, 2);
    if (rmsg(msg, 2) == -1)
      return ('Y');
    sscanf(&msg[1], "%s %s %s", rmtname, tmp1, tmp2);
    sscanf(tmp2, "-x%d", &debuglevel);
    printmsg(M_CALL, "debuglevel level = %d", debuglevel);
    printmsg(M_CALL, "1st msg from remote = %s", msg);
    if(checkname(rmtname))
      return ('Y');
    wmsg("ROK", 2);
    sprintf(msg, "P%s", PROTOS);
    wmsg(msg, 2);
    if (rmsg(msg, 2) == -1)
      return ('Y');
    if (msg[0] != 'U' || index(PROTOS, msg[1]) == (char *) NULL)
      return ('Y');
    setproto(msg[1]);
    return ('R');
   }
}

/*
 * set the protocol
 */
setproto(pr)
char pr;
{
 int i;
 Proto *tproto;

 for(tproto = Protolst; tproto->type != '\0' && pr != tproto->type; tproto++)
    {
     printmsg(M_CALL, "setproto: %c %c", pr, tproto->type);
    }
 if(tproto->type == '\0')
   {
    printmsg(M_ERROR, "setproto:You said I had it but I cant find it");
    exit(1);
   }
 getpkt = tproto->a;
 sendpkt = tproto->b;
 openpk = tproto->c;
 closepk = tproto->d;
}


int prefix(sh, lg)
char *sh, *lg;
{
 return (strncmp(sh, lg, strlen(sh)) == SAME);
}

int notin(sh, lg)
char *sh, *lg;
{
 while(*lg)
      {
       if(prefix(sh, lg++))
	  return (FALSE);
      }
 return (TRUE);
}

#define MAXR 300
int expectstr(str, timeout)
char *str;
{
 static char rdvec[MAXR];
 char *rp = rdvec;
 int kr;
 char nextch;
 
 printmsg(M_CALL, "wanted %s", str);

 if(strcmp(str, "\"\"") == SAME)
   {
    return (TRUE);
   }	
 *rp = 0;
 while(notin(str, rdvec))
      {
       /* fprintf(stderr, "---------->%s<------\n", rdvec);/* */
       kr = sread(&nextch, 1, timeout /* 40 */ );
       /*
	* nextch &= 0177; fprintf(stderr, "kr - %2d '%c'\n", kr, nextch); 
	*/
       if(kr <= 0)
	 {
	  return (FALSE);
	 }
       if ((*rp = nextch & 0177) != '\0')
	 {
	  rp++;
	 }
       *rp = '\0';
       if (rp >= rdvec + MAXR)
	 {
	  return (FALSE);
	 }
      }
 return (TRUE);
}

int writestr(s)
register char *s;
{
 register char last;
 register char *m;
 int nocr;
 
 last = '\0';
 nocr = FALSE;
 while(*s)
      {
       if(last == '\\')
	 {
	  switch(*s)
	        {
		 case 'd':
		 case 'D':		/* delay */
		 		sleep(2);
				break;
		 case 'c':
		 case 'C':		/* end string don't output CR */
				nocr = TRUE;
				break;
		 case 'r':
		 case 'R':		/* carriage return */
		 case 'm':
		 case 'M':
				swrite("\r", 1);
				break;
		 case 'n':
		 case 'N':
				swrite("\n", 1);
				break;
		 case 'b':
		 case 'B':
				swrite("\b", 1);
				break;
		 case 't':
		 case 'T':
				swrite("\t", 1);
				break;
		 case 's':
		 case 'S':
				swrite(" ", 1);
				break;
#ifdef ZSPEED
		 case 'z':
		 case 'Z':
				SIOSpeed(++s);
				while(*s != '\0' && *s != '\\')
				  s++;
				if(*s == '\\')
				  s++;
				break;
#endif ZSPEED
		 default:
				swrite(s, 1);
		}
	  last = '\0';
	 }
       else if (*s != '\\')
	 {
	  swrite(s, 1);
	  /* fputc(*s,stderr); */
	 }
       else
	 {
	  last = *s;
	 }
       s++;
      }
 return (nocr);
}

/*
 *   void sendthem(str)   send line of login sequence
 *         char *str;
 *
 *   return codes:  none
 */

void sendstr(str)
char *str;
{
   int nw, ns;
   int nulls;

   printmsg(M_CALL, "sending %s", str);

#ifdef BREAK
   if(prefix("BREAK", str))
     {
      sscanf(&str[5], "%1d", &nulls);
      if (nulls <= 0 || nulls > 10)
	nulls = 3;
      /* send break */
      ssendbrk(nulls);
      return;
     }
#endif
   
   if(strcmp(str, "EOT") == SAME)
     {
      swrite(EOTMSG, strlen(EOTMSG));
      return;
     }
   if(strcmp(str, "\"\"") == SAME)
      *str = '\0';
   /* fprintf(stderr,"'%s'\n",str); */

   if(strcmp(str, "") != SAME)
     {
      if(!writestr(str))
	{
	 swrite("\r", 1);
	}
     }
   else
     {
      swrite("\r", 1);
     }
   return;
}

int sendexpect(s, e, timeout)
char *s;
char *e;
{
 sendstr(s);
 return (expectstr(e, timeout));
}

#ifdef SLDIAL
dial()
{
 int flg, kk, jj, ll, firstflg;
 char buf[4], *prsend;
 
 char *exp;
 char *alternate;
 int ok;
 int i;
 
 if(strcmp(flds[FLD_TYPE], "HAYES") != SAME)
   {
    printmsg(0, "dial: unsupported dialer %s", flds[FLD_TYPE]);
    return (FALSE);
   }
 printmsg(3, "calling host %s", rmtname);
 if (openline(device, "2400"))
   return (FALSE);
 
 printmsg(0, "hayes: trying 2400");
 if(sendexpect("ATZ", "OK", 2) != TRUE)
   {
    sendexpect("\\d+++\\d", "OK", 2);
    if(sendexpect("ATZ", "OK", 2) != TRUE)
      {
       printmsg(0, "hayes: trying 1200");
       SIOSpeed("1200");
       if(sendexpect("ATZ", "OK", 2) != TRUE)
	 {
	  sendexpect("\\d+++\\d", "OK", 2);
	  if (sendexpect("ATZ", "OK", 2) != TRUE)
	    return (FALSE);
	 }
      }
   }
 printmsg(0, "hayes: got modem response");

 /*
  * (sendstr( "\\d\\dATS7=30" ); expectstr( "OK", 40 ); 
  */

 sendstr("\\d\\dATX4\\c");

 if (sendexpect(speed, "CONNECT ", 40) == TRUE)
   {
    printmsg(3, "hayes: got CONNECT");

    if(sread(buf, 4, 4) == 4)
      {
       printmsg(3, "hayes: speed select %s", buf);
       /* set speed appropriately */
       SIOSpeed(buf);
      }
    return (TRUE);
   }
 else
   return (FALSE);

#endif SLDIAL

/*
 *
 * callup
 * script processor - nothing fancy! 
 */
callup()
{
 int flg, kk, jj, ll, firstflg;
 char *prsend;
 
 char *exp;
 char *alternate;
 int ok;
 int i;
 
 printmsg(M_CALL, "calling host %s", rmtname);
 
 if (strcmp(device, "ACU") == SAME)
   {
    if (dcpdial((char *) NULL, speed, flds[FLD_PHONE]) == FALSE)
      return ('G');
   }
 else if (dcpdial(device, speed, (char *) NULL) == FALSE)
   return ('G');
 
 for (i = FLD_EXPECT; i < kflds; i += 2)
   {
    exp = flds[i];
    printmsg(M_CALL, "callup: expect %d of %d  \"%s\"", i, kflds, exp);
    
    ok = FALSE;
    while(ok != TRUE)
         {
	  alternate = index(exp, '-');
	  if (alternate != (char *) NULL)
	    *alternate++ = '\0';
	  
	  ok = expectstr(exp, 45);
	  
	  printmsg(M_CALL, "got %s", ok != TRUE ? "?" : "that");
	  
	  if (ok == TRUE)
	     break;

	  if (alternate == (char *) NULL)
	    {
	     printmsg(0, "LOGIN FAILED");
	     return ('Y');
	    }
	  exp = index(alternate, '-');
	  if (exp != (char *) NULL)
	    *exp++ = '\0';
	  
	  printmsg(M_CALL, "send alternate");
	  
	  sendstr(alternate);
	 }
    
    printmsg(M_CALL, "callup: send %d of %d \"%s\"", i+1, kflds, flds[i + 1]);
    sleep(1);			/* (1) */
    sendstr(flds[i + 1]);
   }
 return ('P');
}

/*
 *
 * slowrite
 * comunication slow write. needed for auto-baud modems 
 */
/*
 * slowrite(st)
 * register char *st;
 * {
 *  int	len, j;
 *  char c;
 *  len = strlen(st);
 *  printmsg( 2, "sent %s", st );
 *  for(j = 0; j < len; j++) {
 *      swrite(&st[j], 1);
 *	ddelay(80000);
 *  }
 * } 
 */

/*
 *
 * scandir
 *
 * scan work dir for "C." files matching current remote host (rmtname)
 * return: A	- abort
 *	   Y	- can't open file
 *	   S	- ok
 *	   Q	- no files 
 */
scandir()
{
 int fn, len, i;
 char cname[40], tmp[132];
 
 DIR *dirp;
 struct direct *dp;
 
 if ((dirp = opendir(SPOOLDIR)) == NULL)
   {
    printmsg(M_ERROR, "couldn't open dir %s", SPOOLDIR);
    return ('A');
   }
 sprintf(cname, CALLFILE, rmtname);
 len = strlen(cname);
 while((dp = readdir(dirp)) != NULL)
   {
    printmsg(M_INFO, "scandir: %s", dp->d_name);
    if (strncmp(cname, dp->d_name, len) == SAME)
      {
       printmsg(M_INFO, "scandir: match!!");
       sprintf(cfile, "%s/%s", SPOOLDIR, dp->d_name);
       closedir(dirp);
       if ((fw = fopen(cfile, "r")) == NULL)
	 return ('Y');
       return ('S');
      }
   }
 closedir(dirp);
 return ('Q');
}


/*
 * dscandir
 * scan the directory for xqt files
 */
dscandir()
{
 int fn, len, i;
 char tmp[132];
 
 DIR *dirp;
 struct direct *dp;
 
 if((dirp = opendir(SPOOLDIR)) == NULL)
   {
    fprintf(stderr, "couldn't open dir %s\n", SPOOLDIR);
    return (0);
   }
 while((dp = readdir(dirp)) != (struct direct *) NULL)
      {
       printmsg(M_INFO, "dscandir: file = %s", dp->d_name);
       if(strncmp(dp->d_name, "X.", 2) == SAME)
	 {
	  printmsg(M_INFO, "dscandir: match!!");
	  sprintf(cfile, "%s/%s", SPOOLDIR, dp->d_name);
	  closedir(dirp);
	  return (-1);
	 }
      }
 closedir(dirp);
 return (0);
}


