#include <sys/types.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sgtty.h>
#include <errno.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <signal.h>
#include <termcap.h>

#include <lib.h>
#include <time.h>
#include <stdio.h>

#define SHELL1		"/bin/sh"
#define SHELL2		"/usr/bin/sh"
#define MAXWIN		4
#define EMPTY		' ' 
#define SCR_CHR		unsigned short
#define SO		0x0100
#define UL		0x0200
#define TIMEOUT		90

struct wind {
	int pty;	/* file desc. */
	int pid;	/* pid of shell */
	int num;
	int active;
	int xsz, ysz;
	int xpos, ypos;
	int par1, par2;
	int elen;
	SCR_CHR attrib;
	SCR_CHR screen[25][80];
};
	
struct wind wins[MAXWIN], *active;
char shell[64];
int kbd_fd;
char tc[200], termcap[1024],
     *cl,	/* clear screen */
     *cm,	/* goto */
     *ce,	/* clear to end */
     *sr,	/* scroll reverse */
     *so,	/* stand out start */
     *se,	/* stand out end */
     *tp;
int   li, co;   /* lines, columns */     
SCR_CHR cur_att = 0;
     
#define	KEYBOARD	"/dev/tty"
static	struct sgttyb	oldsgttyb;	/* original terminal modes */

EXTERN int select(/* nd, in, out, ex, tv */);

int
OpenKeyboard()
{
	struct sgttyb	newsgttyb;	/* new terminal modes */

	kbd_fd = open(KEYBOARD, O_RDONLY  + O_NONBLOCK );
	if (kbd_fd < 0)
		return -1;

	if (ioctl(kbd_fd, TIOCGETP, &oldsgttyb) < 0) {
		close(kbd_fd);
		kbd_fd = -1;
		return -1;
	}

	newsgttyb = oldsgttyb;
	newsgttyb.sg_flags |= RAW;
	newsgttyb.sg_flags &= ~(EVENP | ODDP | ECHO | XTABS | CRMOD);
	if (ioctl(kbd_fd, TIOCSETP, &newsgttyb) < 0) {
		close(kbd_fd);
		kbd_fd = -1;
		return -1;
	}
	return 0;
}

/*
 * Close the keyboard.
 * This resets the terminal modes.
 */
void
CloseKeyboard()
{
	ioctl(kbd_fd, TIOCSETP, &oldsgttyb);
	close(kbd_fd);
	kbd_fd = -1;
}


int
ReadKeyboard(buf)
	char		*buf;		/* data character */
{
	int	cc;			/* characters read */

	cc = read(kbd_fd, buf, 1);
	if (cc > 0)
		return 1;
	if ((cc < 0) && (errno != EINTR) && (errno != EAGAIN))
		return -1;
	return 0;
}

char user[32], logname[32], home[64], shl[64];
char *env[] = {
  user,
  logname,
  home,
  shl,
  "TERM=wiwi",
  (char *) NULL
};

int newShell(w)
struct wind *w;
{
char name[20];
struct sgttyb args;		/* buffer for TIOCGETP */
struct tchars tchrs;		/* buffer for TIOCGETC */
struct winsize ws;		/* buffer for TIOCSWINSZ */
int i, fd;
int pid;			/* pid of child process */
int status;			/* return status from child process */
static int num;
char *bp, *argx[8];

  for (i = 0; i < 16; i++)
  {
    sprintf(name, "/dev/ptyp%x", i);
    fd = open(name, O_RDWR + O_NONBLOCK);
    if (fd > 0) break;
  }
  if (fd < 0) return -1; /* not posible to open pty */

  ws.ws_row = w->ysz;
  ws.ws_col = w->xsz;
  ioctl(fd, TIOCSWINSZ, &ws);
  
/*   printf("new shell on %s \n", name); */
  if( (pid = fork()) == 0 ) {
	/* Child */
	close(kbd_fd);
	close(fd);
	close(0);				/* just in case */
	close(1);				/* just in case */
	close(2);				/* just in case */
	/* for (i = 3; i < 20; i++) close(i); */

	setpgrp(0, getpid()); /* make new shell a process group leader */

	sprintf(name, "/dev/ttyp%x", i);
	if( open(name, O_RDWR) != 0 ) _exit(-1); /* standard input */
	if(	   dup(0) != 1 ) _exit(-1);	/* standard output */
	if( 	   dup(1) != 2 ) _exit(-1);	/* standard error */

	/* Set line parameters. */

	if (ioctl(0, TIOCGETP, &args) < 0) _exit(-1);
	args.sg_kill = '@';
	args.sg_erase = '\b';
	args.sg_ispeed = args.sg_ospeed = B9600;
	args.sg_flags = BITS8 | ECHO |  CRMOD;
	if(ioctl(0, TIOCSETP, &args) < 0) _exit(-1);
	if(ioctl(0, TIOCGETC, &tchrs) < 0) _exit(-1);
	tchrs.t_intrc = (char)0177;
	tchrs.t_quitc = (char)034;
	tchrs.t_startc = (char)021;
	tchrs.t_stopc = (char)023;
	tchrs.t_eofc = (char)004;
	if(ioctl(0, TIOCSETC, &tchrs) < 0) _exit(-1);
	
	for (i = 1; i <= _NSIG; i++) signal(i, SIG_DFL);
	
	i = 0;
	argx[i++] = "-";
	bp = shell;
	while (*bp) {
		while (*bp && *bp != ' ' && *bp != '\t') bp++;
		if (*bp == ' ' || *bp == '\t') {
			*bp++ = '\0';	/* mark end of string */
			argx[i++] = bp;
		}
	}
	argx[i] = (char *) NULL;
	execve(shell, argx, env);

	_exit(-1);
  } /* end of child */
  if (pid < 0) return -1;
  w->pty = fd;
  w->active = 1;
  w->pid = pid;
  w->num = ++num;
  return fd;
}

void closePty(fd)
int fd;
{
struct sgttyb args;		/* buffer for TIOCGETP */

	args.sg_ispeed = args.sg_ospeed = B0;
	if(ioctl(fd, TIOCSETP, &args) < 0) printf("cann't ioctl \n");
	close(fd);
}

void closeWin(w)
struct wind *w;
{
struct wind *wp;
int s,p;

  closePty(w->pty);
  w->active = 0;
  kill(- w->pid, SIGKILL);
  while (1) {
    p = wait(&s);
    if (p == w->pid) return;
    for (wp = wins; wp < &wins[MAXWIN]; wp++)
      if (wp->pid == p) {
        closePty(wp->pty);
        wp->active = 0;
      }
  }
}

void outc(c)
int c;
{
  putchar(c);
}

void gettermcap()
{
struct winsize ws;		/* buffer for TIOCSWINSZ */

  li = 0;
  co = 0;
  if (ioctl(2, TIOCGWINSZ, &ws) >= 0) {
    li = ws.ws_row;
    co = ws.ws_col;
  }
  if(tgetent(termcap, getenv("TERM")) != 1) {printf("no termcap \n"); exit(-1);}
  if (li == 0 || co == 0) {
    li = tgetnum("li");
    co = tgetnum("co");
  }
  tp = tc;
  cl = tgetstr("cl", &tp);
  cm = tgetstr("cm", &tp);
  ce = tgetstr("ce", &tp);
  sr = tgetstr("sr", &tp);
  so = tgetstr("so", &tp);
  se = tgetstr("se", &tp);
  if (se == (char *) NULL) so = (char *) NULL;
  if (li == 0 || co == 0) {
    printf("unknown window sizes \n");
    exit(-1);
  }
}

void beep()
{
  write(1, "\007", 1);
}

void poscur(x, y)
int x, y;
{
  tputs(tgoto(cm, x, y), 1, outc);
}

void clearWin(w)
struct wind *w;
{
SCR_CHR *cp, *ep;
  
  ep = &w->screen[w->ysz-1][w->xsz-1];
  for (cp = (SCR_CHR *)w->screen; cp <= ep; *cp++ = EMPTY);
  w->xpos = 0;
  w->ypos = 0;
}

void createWin(w, ys, xs, y, x)
struct wind *w;
int ys, xs, y, x;
{
  w->xsz = xs;
  w->ysz = ys;
  w->attrib = 0;
  clearWin(w);
}

void scrollWin(w)
struct wind *w;
{
  SCR_CHR *cp, *dp, *ep;
  
  dp = (SCR_CHR *) w->screen;
  ep = &w->screen[w->ysz-1][w->xsz-1];
  for (cp = &w->screen[1][0]; cp <= ep; *dp++ = *cp++);
  ep = &w->screen[w->ysz-1][w->xsz-1];
  for (cp = &w->screen[w->ysz-1][0]; cp <= ep; *cp++ = EMPTY);
}

void scrollRevWin(w)
struct wind *w;
{
  SCR_CHR *cp, *dp, *ep;
  
  dp = &w->screen[w->ysz-1][w->xsz-1];
  ep = &w->screen[0][0];
  for (cp = &w->screen[w->ysz-2][w->xsz-1]; cp >= ep; *dp-- = *cp--);
  ep = &w->screen[0][w->xsz-1];
  for (cp = &w->screen[0][0]; cp <= ep; *cp++ = EMPTY);
}

void move_to(w, x, y)
struct wind *w;
int x, y;
{
  
  if (x < 0 || x >= w->xsz || y < 0 || y >= w->ysz) {beep(); beep();return;}
  w->xpos = x;
  w->ypos = y;
}

void setAtt(m)
int m;
{
  if (cur_att == (m & 0xff00)) return;
  cur_att = m & 0xff00;
  if (so) {
    if (m & SO) tputs(so, 1, outc);
    else tputs(se, 1, outc);
  }  
}

void refreshWin(w)
struct wind *w;
{
int i;
SCR_CHR *cp, *ep, m;

  if (se) tputs(se, 1, outc);
  cur_att = 0;
  tputs(cl, 1, outc);
  m = cur_att;
  for (i = 0; i < w->ysz; i++)
  {
  	cp = &w->screen[i][0];
  	ep = cp + w->xsz -1;
  	for (; cp <= ep; cp++) {
  	  if (m != (*cp & 0xff00)) {
  	    m = *cp & 0xff00;
  	    setAtt(m);
  	  }
  	  putchar(*cp & 0xff);
  	}
  	if (i < w->ysz-1) puts("\r");
  }
  poscur(w->xpos, w->ypos); fflush(stdout);
}

int sure(s)
char *s;
{
int x, y, l, h, i, j;
fd_set fd;
struct timeval tv;

  tv.tv_sec = 60;
  tv.tv_usec = 0;
  l = strlen(s);
  h = 7;
  if (l < 25) l = 25;
  y = li / 2 - 3;
  x = (co - l) / 2 - 4;
  /* frame */
  poscur(x, y);
  for(i = 0; i < l; i++) putchar('*');
  for (j = 1; j < h-1; j++) {
    poscur(x, y+j);
    for(i = 0; i < l; i++) putchar((i==0 || i==l-1) ? '*' : ' ');
  }
  poscur(x, y+h-1);
  for(i = 0; i < l; i++) putchar('*');
  
  i = (l - strlen(s)) / 2;
  poscur(x+i, y+2);
  printf("%s", s);
  poscur(x+2, y+4);
  printf("are you sure ? [y/n]");
  
  fflush(stdout);
  i = -1;
  do {
  	FD_ZERO(&fd);
  	FD_SET(kbd_fd, &fd);
  	j = select(kbd_fd +1, &fd, NULL, NULL, &tv);
	if (read(kbd_fd, &j, 1) == 1) {
	  if (j == 'y' || j == 'Y') i = 1;
	  else if (j == 'n' || j == 'N') i = 0;
	  else beep();
        } else i = 0;
  } while (i < 0);	
  if (i == 0) refreshWin(active);
  return i;
}

void do_esc(w, c, m)
struct wind *w;
char c;
int m;
{
int v1, v2, ref = 0;
SCR_CHR *cp, *dp, *ep;

  w->elen = 0;
  /* printf("ESC %c %d %d (%d) \n\r", c, w->par2, w->par1, m); */
  if (m) { /* preceding [ */
    v1 = w->par1;
    switch(c) {
      case 'A' : /* cursor up */
        if (v1 < 1) v1 = 1;
        move_to(w, w->xpos, w->ypos - v1);
        break;
      case 'B' : /* cursor down */
        if (v1 < 1) v1 = 1;
        move_to(w, w->xpos, w->ypos + v1);
        break;
      case 'C' : /* cursor right */
        if (v1 < 1) v1 = 1;
        move_to(w, w->xpos + v1, w->ypos);
        break;
      case 'D' : /* cursor left */
        if (v1 < 1) v1 = 1;
        move_to(w, w->xpos - v1, w->ypos);
        break;
      case 'H' : /* move to */
        v2 = w->par2;
        if (v1 < 1) v1 = 1;
        if (v2 < 1) v2 = 1;
        if (v2  > w->ysz ) v2 = w->ysz;
        if (v1  > w->xsz ) v1 = w->xsz;
        move_to(w, v1 -1, v2 -1);
        break;
      case 'J' : /* clear screen from cursor */
        if (v1 <= 0) {
          ep = &w->screen[w->ysz-1][w->xsz-1];
          for (cp = &w->screen[w->ypos][w->xpos]; cp <= ep; *cp++ = EMPTY);
        }
        ref = 1;
        break;
      case 'K' : /* clear line from cursor */
        if (v1 <= 0) {
          ep = &w->screen[w->ypos][w->xsz-1];
          for (cp = &w->screen[w->ypos][w->xpos]; cp <= ep; *cp++ = EMPTY);
          if (w == active) {
		if (ce) tputs(ce, 1, outc);
          	else ref = 1;
	  }
        }
        break;
      case 'L' : /* insert line at cursor */
        if (v1 < 1) v1 = 1;
        ep = &w->screen[w->ypos][0];
        dp = &w->screen[w->ysz-1][w->xsz-1];
        for (cp = &w->screen[w->ysz-1 -v1][w->xsz-1]; cp >= ep; *dp-- = *cp--);
        ep = &w->screen[w->ypos +v1 -1][w->xsz-1];
        for (cp = &w->screen[w->ypos][0]; cp <= ep; *cp++ = EMPTY);
        ref = 1;
        break;
      case 'M' : /* delete line at cursor */
        if (v1 < 1) v1 = 1;
        ep = &w->screen[w->ysz-1][w->xsz-1];
        dp = &w->screen[w->ypos][0];
        for (cp = &w->screen[w->ypos +v1][0]; cp <= ep; *dp++ = *cp++);
        ep = &w->screen[w->ysz-1][w->xsz-1];
        for (cp = &w->screen[w->ysz - v1][0]; cp <= ep; *cp++ = EMPTY);
        ref = 1;
        break;
      case 'P' : /* delete chars at cursor */
        if (v1 < 1) v1 = 1;
        ep = &w->screen[w->ypos][w->xsz-1];
        dp = &w->screen[w->ypos][w->xpos];
        for (cp = &w->screen[w->ypos][w->xpos +v1]; cp <= ep; *dp++ = *cp++);
        ep = &w->screen[w->ypos][w->xsz-1];
        for (cp = &w->screen[w->ypos][w->xsz - v1]; cp <= ep; *cp++ = EMPTY);
        ref = 1;
        break;
      case '@' : /* insert chars at cursor */
        if (v1 < 1) v1 = 1;
        ep = &w->screen[w->ypos][w->xpos];
        dp = &w->screen[w->ypos][w->xsz-1];
        for (cp = &w->screen[w->ypos][w->xsz-1 - v1]; cp >= ep; *dp-- = *cp--);
        ep = &w->screen[w->ypos][w->xpos +v1 -1];
        for (cp = &w->screen[w->ypos][w->xpos]; cp <= ep; *cp++ = EMPTY);
        ref = 1;
        break;
      case 'm' :
        switch (v1) {
          case 7 : w->attrib |= SO; break;
          case 4 : w->attrib |= UL; break;
          case 0 : w->attrib = 0; break;
        }
        if (w == active) setAtt(w->attrib);
        break;
    }
  } else {
    if (c == 'M') {
      if (w->ypos == 0) { scrollRevWin(w); }
      else w->ypos--;
      if (w == active) {
	if (sr) tputs(sr, 1, outc);
        	else ref = 1;
      }
    }
  }
  if (w != active) return;
  if (ref) refreshWin(w);
  else poscur(w->xpos, w->ypos);
}


#define newline {if (++w->ypos >= w->ysz) { w->ypos--; scrollWin(w); } \
                 if (w == active) putchar('\n');}

void outWin(w, s)
struct wind *w;
char *s;
{
char *ip = s;
int ts;

  setAtt(w->attrib);
  while (*ip)
  {
    if (w->elen) { /* pending escape sequence */
      if (w->elen++ == 1) {
        if (*ip != '[') do_esc(w, *ip, 0);
      } else {
        if (isdigit(*ip)) {
          if (w->par1 == -1) w->par1 = *ip -'0';
          else w->par1 = w->par1 * 10 + *ip - '0';
        } else if (*ip == ';') {
          w->par2 = w->par1;
          w->par1 = -1;
        } else {
          do_esc(w, *ip, 1);
        }
      }
      ip++;
    } else if (*ip < 0xff && *ip >= ' ' && *ip != 0x7f) {
      if (w == active) putchar(*ip);
      w->screen[w->ypos][w->xpos++] = *ip++ | w->attrib;
      if (w->xpos >= w->xsz) { /* rechter Rand */
        w->xpos = 0;
        newline
        if (w == active) putchar('\r');
      }
    } else {
      switch(*ip++) {
      	case '\n' :
      	  newline;
          break;
      	case '\r' :
      	  w->xpos = 0;
          if (w == active) putchar('\r');
          break;
      	case 7 : beep();
      	  break;
      	case 'H'&31 :
      	  if (w->xpos > 0)  {
      	    w->xpos--;
            /* w->screen[w->ypos][w->xpos] = ' ' | w->attrib; NON-DEST */
            if (w == active) putchar('H'&31);
      	  }
      	  break;
        case '\t' :
          ts = (w->xpos + 8) & 0xFFF8;
          if (ts >= w->xsz) newline
          else { for (; w->xpos < ts; w->xpos++) {
           	w->screen[w->ypos][w->xpos] = ' ' | w->attrib;
          	if (w == active) putchar(' ');
          	}
          }
          break; 
        case 033 :
          w->elen = 1;
          w->par1 = w->par2 = -1;
          break;
        case 000 :
          break;  
        default :
          printf("#%03d#", *--ip);
          w->xpos += 5;
          ip++;
      } /* switch */
    }
  } /* end while */
  fflush(stdout);
}

void onhup()
{
  printf("\rSIGNAL HUP received\r\n");
  signal(SIGHUP, onhup);
}

int blank()
{
int res, x, y;
fd_set fd;
struct timeval tv;
struct wind *wptr;

	tputs(cl, 1, outc);
	tv.tv_sec = 2;
	tv.tv_usec = 0;
	do {
		x = x * 47 + 13;
		y = y * 13 + 47;
		x %= co;
		y %= li;
		poscur(x, y);
		fflush(stdout);
  		FD_ZERO(&fd);
  		FD_SET(kbd_fd, &fd);
		for (wptr = wins; wptr < &wins[MAXWIN]; wptr++) {
		  if (wptr->active) FD_SET(wptr->pty, &fd);
		}  
  		res = select(FD_SETSIZE, &fd, NULL, NULL, &tv);
  	} while (res == 0);	
	refreshWin(active);
	if (FD_ISSET(kbd_fd, &fd)) {
		read(kbd_fd, &res, 1);
		return 0;
	}	
	return res;
}


int menu(c)
char c;
{
int i;

  switch(c) {
    case 'x' : return sure("EXIT Window Manager");
    case '0' :
	c = '1' + 10;
    case '1' :
    case '2' :
    case '3' :
    case '4' :
    case '5' :
    case '6' :
    case '7' :
    case '8' :
    case '9' :
      i = c - '1';
      if (i < MAXWIN && wins[i].active) {
        active = &wins[i];
        refreshWin(active);
      }
      break;
    case 'r' : 
      refreshWin(active);
      break;
    case 'n' :  
      for (i = 0; i < MAXWIN; i++) if (! wins[i].active) break;
      if (i >= MAXWIN) { beep(); return 0;}
      createWin(&wins[i], li, co, 0, 0);
      newShell(&wins[i]);
      active = &wins[i];
      refreshWin(active);
      break;
    case 'q' :
      if (sure("KILL Window") == 0) return 0;
      closeWin(active);
      for (i = 0; i < MAXWIN; i++)
        if (wins[i].active) { active = &wins[i]; 
          refreshWin(active);
          return 0;
        }
      return 1;  /* last window deleted */
    case '\t' :  
      do
	if (++active >= &wins[MAXWIN])
	active = wins;
      while (active->active == 0);  
      refreshWin(active);
      break;
    case '':  
      write(active->pty, &c, 1);
      break;
    default :
      beep();
  }
  return 0;
}

void main()
{
	char str[501], *ep;
	char escape[10];
	int d, c, c2, s, res;
	struct wind *wptr;
	struct timeval tv;
	fd_set fd;
	
	strcpy(shell, "/bin/sh");
	if ((ep = getenv("SHELL"))) strcpy(shell, ep);
	/* set enviromen for shells */
	strcpy(user, "USER=");
	if ((ep = getenv("USER"))) strcat(user, ep);
	strcpy(home, "HOME=");
	if ((ep = getenv("HOME"))) strcat(home, ep);
	strcpy(logname, "LOGNAME=");
	if ((ep = getenv("LOGNAME"))) strcat(logname, ep);
	strcpy(shl, "SHELL=");
	strcat(shl, shell);
	tv.tv_sec = TIMEOUT;
	tv.tv_usec = 0;
	
	gettermcap();

	tputs(cl, 1, outc);
	OpenKeyboard();
	createWin(&wins[0], li, co, 0, 0);
	createWin(&wins[1], li, co, 0, 0);
	newShell(&wins[0]);
	newShell(&wins[1]);
	active = wins;
	while(1)
	{
		if (ReadKeyboard(&c) == 1) {
		        if (c2 == -1) {
		          c2 = 0;
		          if (menu(c)) goto end;
		        /*  
			} else if (c == '\t') {
				do
				if (++active >= &wins[MAXWIN])
				  active = wins;
				while (active->active == 0);  
					refreshWin(active);
			*/	
			}
			else if (c == '') c2 = -1;
			else if (c == '\033') {
			  s = 0;
			  do {
			    escape[s++] = c;
			    if (s > 8 || c > '@') break;
			  } while (ReadKeyboard(&c) == 1);  
			  write(active->pty, escape, s);
			}
			else {
				write(active->pty, &c, 1);
			}
		}
  		FD_ZERO(&fd);
  		FD_SET(kbd_fd, &fd);
		for (wptr = wins; wptr < &wins[MAXWIN]; wptr++) {
		  if (wptr->active) FD_SET(wptr->pty, &fd);
		}  
  		res = select(FD_SETSIZE, &fd, NULL, NULL, &tv);
  		if (res == 0) {
  		  res = blank();
  		} else if (res < 0) continue;
		for (wptr = wins; wptr < &wins[MAXWIN]; wptr++) {
		  if (! wptr->active) continue;
		  if (! FD_ISSET(wptr->pty, &fd)) continue;
		  d = read(wptr->pty, str, 500);
		  if (d > 0) {
		    str[d] = '\0';
		    outWin(wptr, str);
		  }
		}
	}
end:
        /* tputs(cl, 1, outc); */
	poscur(0, li-1);
	for (wptr = wins; wptr < &wins[MAXWIN]; wptr++)
	  if (wptr->active) closeWin(wptr);
	CloseKeyboard();
}
