/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Formulate an Internet address from network + host.
 *		Used in building addresses stored in the ifnet structure.
 *
 * Version:	@(#)inet/in_mkaddr.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <arpa/inet.h>
#include <inet/in.h>


u_long inet_makeaddr(net, host)
u_long net, host;
{
  u_long addr;

  if (net < 128) addr = (net << IN_CLASSA_NSHIFT) | (host & IN_CLASSA_HOST);
    else if (net < 65536)
		addr = (net << IN_CLASSB_NSHIFT) | (host & IN_CLASSB_HOST);
    else if (net < 16777216L)
		addr = (net << IN_CLASSC_NSHIFT) | (host & IN_CLASSC_HOST);
    else addr = net | host;
  addr = htonl(addr);
  return(addr);
}
