/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file handles local network addr extraction.
 *
 * Version:	@(#)inet/in_lnaof.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <lib.h>
#include <arpa/inet.h>
#include <inet/in.h>


u_long inet_lnaof(in)
u_long in;
{
  register u_long i = ntohl(in);

  if (IN_CLASSA(i)) return((i)&IN_CLASSA_HOST);
    else if (IN_CLASSB(i)) return((i)&IN_CLASSB_HOST);
    else return((i)&IN_CLASSC_HOST);
}
