/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file converts from the host's byte ordering to
 *		the byte ordering as used on the network.
 *
 * Version:	@(#)inet/htonl.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <arpa/internet.h>
#include <inet/in.h>


#define LITTLE_ENDIAN		1
#define BIG_ENDIAN		2


#define ENDIAN			LITTLE_ENDIAN


u_long htonl(num)
u_long num;
{
#if (ENDIAN == LITTLE_ENDIAN)
  u_long ret;
  int l, h;

  l = (num & 0xFFFF);
  h = ((num >> 16) & 0xFFFF);

  ret = ( (((u_long)htons(l)) << 16) | htons(h) );
  return(ret);
#else
  return(num);
#endif
}
