/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Various functions. We should minimize this file...
 *
 * Version:	@(#)other.c		1.00	07/08/92
 *
 * Authors:	Original by Phil Karn KA9Q.
 *		Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include "tnet.h"

#include <inet/in.h>
#include <time.h>
#include <stdarg.h>
#include <stdio.h>

#include "netuser.h"

#ifndef	_NFILES
#   ifdef	NFILES
#	define	_NFILES    NFILES
#   else
#	define	_NFILES    25
#   endif
#endif


static time_t timebase=0;
int net_error;


short clksec()
{
  if (timebase == 0) (void)time(&timebase);
  return(time(0) - timebase);
}


static istate = 1;
short disable()
{
  int tmp;

  tmp = istate;
  istate = 0;
  return(tmp);
}


void restore(s)
int s;
{
  istate = s;
}


void rprintf(fdout, format)
int fdout;
char *format;
{
  char buffer[256];
  register int count;
  va_list argptr;

  if (fdout >= 0) {
	va_start(argptr, format);
	vsprintf(buffer, format, argptr);
	count = strlen(buffer);
	va_end(argptr);

	(void) write(fdout, buffer, count);
  }
}


void closefiles()
{
  int i;

  for(i = 3; i < _NFILES; i++) (void) close(i);
}


/*
 * Convert a socket (address + port) to an ASCII string
 * of the form aaa.aaa.aaa.aaa:pppp
 */
char *psocket(s)
struct socket *s;
{
  static char buf[30];

  sprintf(buf,"%s:%u",inet_ntoa(ntohl(s->address)),s->port);
  return(buf);
}
