/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Global structures and constants needed by an Internet
 *		user process.
 *
 * Version:	@(#)netuser.h		1.00	07/12/92
 *
 * Authors:	Original by Phil Karn KA9Q.
 *		Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */

#define	NCONN	50		/* Maximum number of open network connections */

#define	DISCARD_PORT	9
#define ECHO_PORT	7

extern int32 ip_addr;	/* Our IP address */

extern int net_error;	/* Error return code */
#define	NONE	0		/* No error */
#define	CON_EXISTS	1	/* Connection already exists */
#define	NO_CONN	2		/* Connection does not exist */
#define	CON_CLOS	3	/* Connection closing */
#define	NO_SPACE	4	/* No memory for TCB creation */
#define	WOULDBLK	5	/* Would block */
#define	NOPROTO		6	/* Protocol or mode not supported */
#define	INVALID		7	/* Invalid arguments */

/* Codes for the tcp_open call */
#define	TCP_PASSIVE	0
#define	TCP_ACTIVE	1

/* Socket structure */
struct socket {
	int32 address;		/* IP address */
	int16 port;			/* port number */
};

/* Connection structure (two sockets) */
struct connection {
	struct socket local;
	struct socket remote;
};
#define	NULLSOCK	(struct socket *)NULL
