/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file contains some important definitions, and the
 *		prototypes of several "global" functions.
 *
 * Version:	@(#)global.h		1.00	07/12/92
 *
 * Authors:	Original by Phil Karn KA9Q.
 *		Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */

#define	TRUE	1
#define	FALSE	0

extern char *tcpstates[];
extern int shutdown;
extern int16 lport;
extern int debug;
extern int32 ip_addr;


/* These are also in <stdlib.h> !!!! */
_PROTOTYPE( void *malloc, (unsigned size)				);
_PROTOTYPE( void *calloc, (unsigned num, unsigned size)			);

/* other.c: */
_PROTOTYPE( void closefiles, (void)					);
_PROTOTYPE( void rprintf, (int fdout, char *fmt)			);
_PROTOTYPE( char *psocket, (struct socket *s)				);

/* route.c: */
_PROTOTYPE( struct route *rt_lookup, (int32 target)			);
_PROTOTYPE( int rt_add, (int 32 target, int32 gw, int metric,		\
			 struct interface *if)				);
_PROTOTYPE( int rt_drop, (int32 target)					);
_PROTOTYPE( int rt_dump, (int fdout)					);

/* servers.c: */
_PROTOTYPE( void di_start, (void)					);
_PROTOTYPE( void di_stop, (void)					);
_PROTOTYPE( void ec_start, (void)					);
_PROTOTYPE( void ec_stop, (void)					);
