/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Definitions for accessing the TNET kernel.
 *
 * Version:	@(#)tnet/client.h	1.00		07/12/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#ifndef _TNET_CLIENT_H
#define _TNET_CLIENT_H

#include <tnet/tnet.h>

/* Valid opcodes. */
#define RMT_EXIT	1		/* terminate the TNET kernel	*/
#define RMT_STOP	2		/* suspend the TNET kernel	*/
#define RMT_START	3		/* restart the TNET kernel	*/
#define RMT_SHID	4		/* set the host ID		*/
#define RMT_GHID	5		/* get the host ID		*/
#define RMT_SHNAME	6		/* set the host name		*/
#define RMT_GHNAME	7		/* get the host name		*/
#define RMT_SDNAME	8		/* set the domain name		*/
#define RMT_GDNAME	9		/* get the domain name		*/
#define RMT_CONNECT	10		/* make a network connection	*/
#define RMT_ATTACH	12		/* attach a device driver	*/
#define RMT_DETACH	13		/* detach a device driver	*/
#define RMT_IFCONFIG	14		/* configure an interface	*/
#define RMT_ROUTE	15		/* manage the IP routing table	*/
#define RMT_ARP		16		/* manage the ARP cache		*/
#define RMT_IP		17		/* handle IP variables		*/
#define RMT_TCP		18		/* handle TCP variables		*/
#define RMT_STAT	19		/* handle the STAT call		*/

/* This is the TNET COMMAND message structure. */
typedef struct {
  u_short	c_opcode;		/* what system call is desired	*/
  u_short	c_pid;			/* process ID of caller		*/
  u_short	c_uid;			/* (effective) UID of caller	*/
  char		c_return[14];		/* name of return pipe		*/
  u_short	c_i1, c_i2, c_i3;	/* three integer parameters	*/
  u_long	c_l1, c_l2, c_l3;	/* three long int parameters	*/
  u_short  	c_length;		/* length of data portion	*/
} RMTHDR;
#define RMTHDR_LEN	(sizeof(RMTHDR))


/* Error codes returned by the client() call. */
#define ECLIXPIPE	(-501)		/* cannot create client pipe	*/
#define ECLITNETP	(-502)		/* cannot open( TNET pipe	*/
#define ECLIWCMD	(-503)		/* cannot write TNET command	*/
#define ECLIRETPIPE	(-504)		/* cannot open return pipe	*/
#define ECLIRSTATUS	(-505)		/* cannot read status		*/
#define ECLIMYPIPE	(-506)		/* cannot read name of my pipe	*/
#define ECLIMYOPEN	(-507)		/* cannot open my pipe		*/
#define ETIMEDOUT	(-508)		/* timed out!!!			*/

/* This structure defines the ATTACH command. */
struct attach {
  u_short	class;			/* ATTCH_SLIP et al		*/
  u_short	mtu;			/* max. transfer unit		*/
  u_short	buffers;		/* number of allocated buffers	*/
  char		device[16];		/* UNIX device file in /dev	*/
  char		label[16];		/* interface label ("name")	*/
  char		speed[16];		/* interface line speed (SLIP)	*/
  char		telno[128];		/* tel# to be dialed (SLIP)	*/
};
#define ATTCH_SLIP	1		/* attach a SLIP class device	*/
#define ATTCH_CSLIP	2		/* attach a CSLIP class device	*/
#define ATTCH_PPP	3		/* attach a PPP class device	*/
#define ATTCH_ETHER	4		/* attach a ETHER class device	*/

/* This structure defines the ROUTE command. */
struct uroute {
  u_long	target;			/* target IP address		*/
  u_long	gateway;		/* gateway IP afddress		*/
  int		metric;			/* hop count			*/
  char		iface[16];		/* name of connected interface	*/
};
#define ROUTE_ADD	1		/* add a new route to the table	*/
#define ROUTE_DROP	2		/* remove route from the table	*/
#define ROUTE_DUMP	3		/* show the IP routing table	*/

/* This structure defines the STAT command. */
#define	STAT_DUMP	1

/* This structure defines the ARP command. */
struct uarp {
  u_long	target;			/* target IP address		*/
  int		hwtype;			/* hardware type		*/
  int		hwlen;			/* hardware address length	*/
  char		hwaddr[16];		/* space for hardware address	*/
};
#define ARP_DUMP	1		/* dump the ARP cache		*/
#define ARP_ADD		2		/* add entry to the ARP cache	*/
#define ARP_DROP	3		/* remove entry from cache	*/
#define ARP_FLUSH	4		/* flush the ARP cache		*/
#define ARP_PUBLISH	5		/* publish an ARP mapping	*/

/* These definitions are for the IP command. */
#define IPVAL_TTL	1		/* set/show the IP "maxttl" val	*/

/* These definitions are for the TCP command. */
#define TCPVAL_WINDOW	1		/* set/show the TCP "window" val*/
#define TCPVAL_MSS	2		/* set/show the TCP "mss" val	*/


/* Function prototyping according to ANSI. */
#ifndef _PROTOTYPE
#    if _MINIX
#	include <ansi.h>
#    else
#	define _ANSI		0
#	ifdef __STDC__		
#	    if (__STDC__ == 1)	
#	    	undef _ANSI
#	    	define _ANSI	1
#	    endif
#	endif
#	if _ANSI
#	    define	_PROTOTYPE(function, params)	function params
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST		const
#	    define	_VOLATILE	volatile
#	    define	_SIZET		size_t
#	else
#	    define	_PROTOTYPE(function, params)	function()
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST
#	    define	_VOLATILE
#	    define	_SIZET		int
#	endif /* _ANSI */
#    endif /* _MINIX */
#endif	/* _PROTOTYPE */

/* MINIX cannot handle BSD-ish long names. */
#if _MINIX
#   define getdomainname	gdname
#   define gethostid		ghostid
#   define gethostname		ghname
#   define getpeername		gpname
#   define getsockname		gsname
#   define setdomainname	sdname
#   define sethostid		shostid
#   define sethostname		shname
#endif

_PROTOTYPE( int tn_rlink, (RMTHDR *msgptr, char *bufp, int buflen,	\
			  int timeout, int *fd_in)			);
_PROTOTYPE( int sethostid, (u_long id)					);
_PROTOTYPE( u_long gethostid, (void)					);
_PROTOTYPE( int sethostname, (char *name, int length)			);
_PROTOTYPE( int gethostname, (char *mybuff, int length)			);
_PROTOTYPE( int setdomainname, (char *name, int length)			);
_PROTOTYPE( int getdomainname, (char *mybuff, int length)		);

_PROTOTYPE( int client, (int protocol, u_short lport, u_short port,	\
			 u_long ipaddr,	 int *netin, int *netout)	);
_PROTOTYPE( int tconnect, (int protocol, u_short *lport, u_short *port,	\
			  u_long *ipaddr, u_long flags,			\
			  int *netin, int *netout)			);

#endif /* _TNET_CLIENT_H */
