include/netinet/socket.h                                                                            000644  000000  000000  00000006533 05341761352 021514  1include/inet/socket.h                                                                               ustar   root                            root                            000273  000272                                                                                                                                                                         include/netinet/un.h                                                                                000644  000000  000000  00000001125 05224732630 017747  1include/inet/un.h                                                                                   ustar   root                            root                            000302  000310                                                                                                                                                                         include/netdb.h                                                                                     000644  000000  000000  00000011352 05235622444 012374  0                                                                                                    ustar   root                            root                                                                                                                                                                                                                   /*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Structures returned by network data base library.
 *		All addresses are supplied in host order, and
 *		returned in network order (suitable for use in system calls).
 *
 * Version:	@(#)netdb.h		1.00		07/02/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#ifndef _NETDB_H
#define _NETDB_H

#include <arpa/internet.h>

#define _PATH_HOSTS		"/etc/tnet/hosts"
#define _PATH_NETWORKS		"/etc/tnet/networks"
#define _PATH_PROTOCOLS		"/etc/tnet/protocols"
#define _PATH_SERVICES		"/etc/tnet/services"
#define _PATH_RESCONF		"/etc/tnet/resolv.conf"


struct	hostent {
  char	*h_name;		/* official name of host		*/
  char	**h_aliases;		/* alias list				*/
  int	h_addrtype;		/* host address type			*/
  int	h_length;		/* length of address			*/
  char	**h_addr_list;		/* list of addresses from name server	*/
};
#define	h_addr	h_addr_list[0]	/* address, for backward compatiblity	*/


/*
 * Assumption here is that a network number
 * fits in 32 bits -- probably a poor one.
 */
struct	netent {
  char		*n_name;	/* official name of net			*/
  char		**n_aliases;	/* alias list				*/
  int		n_addrtype;	/* net address type			*/
  u_long	n_net;		/* network #				*/
};

struct	servent {
  char		*s_name;	/* official service name		*/
  char		**s_aliases;	/* alias list				*/
  int		s_port;		/* port #				*/
  char		*s_proto;	/* protocol to use			*/
};

struct	protoent {
  char		*p_name;	/* official protocol name		*/
  char		**p_aliases;	/* alias list				*/
  int		p_proto;	/* protocol #				*/
};


/* Mappings for long names- poor Old MINIX :-( */
#if _MINIX
#   define sethostent		shostent
#   define endhostent		ehostent
#   define sethostfile		shstfile
#   define gethostbyname	ghbyname
#   define gethostbyaddr	ghbyaddr
#   define setnetent		snetent
#   define endnetent		enetent
#   define getnetent		gnetent
#   define getnetbyaddr		gnbyaddr
#   define getnetbyname		gnbyname
#   define setprotoent		sprotent
#   define endprotoent		eprotent
#   define getprotoent		gprotent
#   define getprotobynumber	gpbynumb
#   define getprotobyname	gpbyname
#   define setservent		sservent
#   define endservent		eservent
#   define getservent		gservent
#   define getservbyname	gsbyname
#   define getservbyport	gsbyport
#endif

/* Function prototyping according to ANSI. */
#ifndef _PROTOTYPE
#    if _MINIX
#	include <ansi.h>
#    else
#	define _ANSI		0
#	ifdef __STDC__		
#	    if (__STDC__ == 1)	
#	    	undef _ANSI
#	    	define _ANSI	1
#	    endif
#	endif
#	if _ANSI
#	    define	_PROTOTYPE(function, params)	function params
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST		const
#	    define	_VOLATILE	volatile
#	    define	_SIZET		size_t
#	else
#	    define	_PROTOTYPE(function, params)	function()
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST
#	    define	_VOLATILE
#	    define	_SIZET		int
#	endif /* _ANSI */
#    endif /* _MINIX */
#endif	/* _PROTOTYPE */

_PROTOTYPE( void sethostent, (int stayopen)				);
_PROTOTYPE( void endhostent, (void)					);
_PROTOTYPE( void sethostfile, (char *name)				);
_PROTOTYPE( struct hostent *gethostbyname, (char *name)			);
_PROTOTYPE( struct hostent *gethostbyaddr, (char *addr, int len, int type));
_PROTOTYPE( void setnetent, (int f)					);
_PROTOTYPE( void endnetent, (void)					);
_PROTOTYPE( struct netent *getnetent, (void)				);
_PROTOTYPE( struct netent *getnetbyaddr, (u_long net, int type)