/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file contains an implementation of the "server"
 *		for the TIMEP protocol, as described in RFC 868.  This
 *		protocol can be used to ask servers like this one for
 *		their current time-and-day.
 *
 * Usage:	timed [-dv]
 *
 * Version:	@(#)timed.c		1.00	07/02/92
 *
 * Authors:	Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <tnet/tnet.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdio.h>


static char *Version = "@(#) timed 1.00 (07/02/92)";


int opt_d = 0;				/* debugging output flag	*/


_PROTOTYPE( int timed, (void)						);


extern int getopt(), optind, opterr;
extern char *optarg;


/* Answer an incoming TIMEP request. */
int timed()
{
  time_t now;
  time_t nettime;
  u_long val;

  (void) time(&now);
  nettime = now + (time_t) 2208988800L;	/* adjust for 1 Jan 1900 GMT */
  val = (u_long) nettime;
  val = htonl(val);

  if (opt_d == 1) fprintf(stderr,
	"timed: now=%08lx nettime=%08lx val=%08lx\n", now, nettime, val);
    else (void) write(1, (char *) &val, sizeof(u_long));

  return(0);
}


void usage()
{
  fprintf(stderr, "Usage: timed [-dv]\n");
  exit(-1);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char who[128];
  register int c;

  opterr = 0;
  while ((c = getopt(argc, argv, "dv")) != EOF) switch(c) {
	case 'd':
	case 'v':
		opt_d = 1;
		break;
	default:
		usage();
  }

  /* No more arguments allowed. */
  if (optind != argc) usage();

  /* Start the server. */
  c = timed();

  return(c);
}
