/* telnet by Michael Temari 06/21/92 */

#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <arpa/telnet.h>
#include <inet/in.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <sgtty.h>
#include <ctype.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <signal.h>
#include <errno.h>

#include "telnet.h"

_PROTOTYPE( int get_pty, (int *, int *)					);

extern int getopt(), optind, opterr;
extern char *optarg;

#define	DATA	0
#define	COMMAND	1

static char escape = 0x1d;

int keyfd, keypid = -1;

int opt_d = 0, opt_b = 0, opt_t = 0;

void getkeys()
{
char keys[10];
int s, ppid;

   ppid = getppid();

   while(1) {
	s = read(0, keys, sizeof(keys));
	if(s > 0) {
		write(1, keys, s);
		kill(ppid, SIGUSR1);
	}
   }
}

int start_keyboard()
{
int pfd[2];

   if(pipe(pfd) < 0)
	return(-1);

   switch(keypid = fork()) {
	case -1:perror("Error forking keyboard reader!");
		return(-1);
	case 0:	close(1);
		dup(pfd[1]);
		close(pfd[0]);
		getkeys();
		exit(0);
   }
   close(pfd[1]);
   keyfd = pfd[0];
   fcntl(keyfd, F_SETFL, O_NONBLOCK);
}

void gotkey()
{
   signal(SIGUSR1, gotkey);
}

static char buffer[2048];

void doshell()
{
int pid, c;
char *shell;

   if(keypid != -1)
	kill(keypid, SIGKILL);
  tel_save();
  printf("\r\n");
  /* Fork off a child process and have it execute shell(1). */
  if ((pid = fork()) == 0) {
	for (c = 3; c < 50; c++) (void) close(c);
	shell = getenv("SHELL");
	if(shell != (char *)NULL)
		(void) execl(shell, shell,         (char *)NULL);
	(void) execl("bin/sh",      "/bin/sh",     (char *)NULL);
	(void) execl("/usr/bin/sh", "/usr/bin/sh", (char *)NULL);
	(void) fprintf(stderr, "EXEC of shell failed!\r\n");
  } else if (pid < 0) {
	fprintf(stderr, "Fork call failed!\r\n");
	return;
  }
  while(wait((int *)NULL) != pid) ;
  tel_rest();
  (void) start_keyboard();
}

void usage()
{
  fprintf(stderr, "Usage: telnet [-bdv] host [port]\n");
  exit(-1);
}

main(argc, argv)
int argc;
char *argv[];
{
int netin, netout;
register int i;
u_short port;
u_long hostip;
struct hostent *hp;
struct servent *sp;
int s, ok;
int devin, devout;
char c;
char *host;
int mode;

  opterr = 0;
  while ((i = getopt(argc, argv, "dvbt")) != EOF) switch(i) {
	case 'd':
	case 'v':
		opt_d = 1;
		break;
	case 'b':
		opt_b = 1;
		break;
	case 't':
		opt_t = 1;
		break;
	default:
		usage();
  }

  /* At least one more argument needed. */
  if ((argc - optind) < 1) usage();

  host = argv[optind++];


  if (optind == argc) {
	if ((sp = getservbyname("telnet", "tcp")) == (struct servent *)NULL) {
		fprintf(stderr, "TELNET port is unknown????\n");
		return(-1);
	} else port = sp->s_port;
   } else
	port = (u_short) atoi(argv[optind++]);

  if(optind != argc) usage();



  if (opt_d == 1) fprintf(stderr, "Resolving %s...", host);


  hp = gethostbyname(host);
  if (hp == (struct hostent *)NULL) {
	hostip = (u_long)0;
	printf("Unresolved host %s\n", host);
	return(0);
  } else
	memcpy((char *) &hostip, (char *) hp->h_addr, hp->h_length);

  if (opt_d == 1) fprintf(stderr, " trying %s:%d...\n",
				inet_ntoa(hostip), port);

   s = client(TCP_PTCL, (u_short)0, port, hostip, &netin, &netout);
   if(s != 0) {
	printf("Error %d connecting to host.\n", s);
	return(0);
   }

   ok = 1;

   for(i = 1; i <= _NSIG; i++)
	signal(i, SIG_IGN);

   tel_init();

   if(opt_t) {
	if(get_pty(&devin, &devout))
		ok = 0;
   } else {
	devout = 1;
	if(start_keyboard())
		ok = 0;
	signal(SIGUSR1, gotkey);
   }

   if(ok && opt_b) {
	telopt(netout, WILL, TELOPT_BINARY);
	telopt(netout, DO, TELOPT_BINARY);
   }

   while(ok) {
	s = read(netin, buffer, sizeof(buffer));
	if(s == 0) break;
	if(s == -1 && errno != EINTR) break;
	if(s > 0)
		tel_in(devout, netout, buffer, s);
	if(opt_t) {
		s = read(devin, buffer, sizeof(buffer));
		if(s == 0) break;
		if(s == -1 && errno != EINTR) break;
		if(s > 0)
			tel_out(netout, buffer, s);
		continue;
	}
	while(1) {
		s = read(keyfd, &c, 1);
		if(s == 0)
			ok = 0;
		if(s <= 0) break;
		if(c == escape)
			if(mode == COMMAND)
				mode = DATA;
			else {
				mode = COMMAND;
				continue;
			}
		if(mode == COMMAND) {
			switch(c) {
				case 'q': ok = 0; break;
				case '!': doshell();
				case '\r':
				case '\n': mode = DATA; printf("\r\n"); break;
				default: printf("Valid commands are:\r\n");
					 printf("   q - quit\r\n");
					 printf("   ! - shell escape\r\n");
					 printf("telnet>");
			}
			continue;
		}
		tel_out(netout, &c, s);
	}
   }
   if(keypid != -1)
	kill(keypid, SIGKILL);
   tel_stop();
   close(netin); close(netout);
}
