#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <string.h>
#include <signal.h>
#include <stdio.h>
#include "paths.h"
#include <protocols/talkd.h>

#define	TIMEOUT	30

struct socket {
	u_long address;
	u_short port;
};

struct udp_hdr {
	int size;
	struct socket lsocket;
	struct socket fsocket;
};

CTL_MSG		request;
CTL_RESPONSE	response;

char	hostname[32];
int	debug = 0;

void wake_up()
{
   signal(SIGALRM, wake_up);
}

main(argc, argv)
int argc;
char *argv[];
{
struct udp_hdr udp_hdr;
u_short lport, rport;
u_long raddr;
int s, netin, netout;
struct servent *sp;
int i;


   if(getuid()) {
	fprintf(stderr, "talkd: not super-user\n");
	exit(1);
   }
   if(chdir(_PATH_DEV) < 0) {
	fprintf(stderr, "talkd: Couldn't chdir to %s\n", _PATH_DEV);
	exit(1);
   }
   if(argc > 1 && strcmp(argv[1], "-d") == 0)
	debug = 1;

   if(gethostname(hostname, sizeof(hostname) - 1) < 0) {
	fprintf(stderr, "talkd: Couldn't get hostname\n");
	exit(1);
   }
   if ((sp = getservbyname("ntalk", "udp")) == (struct servent *)NULL) {
	fprintf(stderr, "TALKD port is unknown????\n");
	return(-1);
   } else
	lport = sp->s_port;

   rport = (u_long)0;
   raddr = (u_long)0;
   s = tconnect(UDP_PTCL, &lport, &rport, &raddr, 0L, &netin, &netout);
   if(s != 0) {
	fprintf(stderr, "Connect error %d\n", s);
	exit(-1);
   }
#if 0
   (void) close(0); (void) close(1); (void) close(2);
#endif
   while(1) {
	signal(SIGALRM, wake_up);
	alarm(TIMEOUT);
	s = read(netin, &udp_hdr, sizeof(struct udp_hdr));
#if 0
	fprintf(stderr, "UDP HEADER READ %d\n", s);
	fprintf(stderr, "size = %d\n", udp_hdr.size);
	fprintf(stderr, "lsocket: %ld %d\n", udp_hdr.lsocket.address, udp_hdr.lsocket.port);
	fprintf(stderr, "fsocket: %ld %d\n", udp_hdr.fsocket.address, udp_hdr.fsocket.port);
#endif
	alarm(0);
	if(s == 0) break;
	if(s == sizeof(struct udp_hdr)) {
		s = read(netin, (char *)&request, udp_hdr.size);
		if(s == 0) break;
		if(s != udp_hdr.size) {
			fprintf(stderr, "talkd: read udp %d != %d\n",
				s, udp_hdr.size);
			break;
		}
#if 0
		fprintf(stderr, "Talk vers %d  type %d    id %ld\n",
			request.vers, request.type, request.id_num);
		fprintf(stderr, "Pid %ld\n", request.pid);
		fprintf(stderr, "Lname %-12s  Rname %-12s\n",
			request.l_name, request.r_name);
		fprintf(stderr, "Tty %16s\n", request.r_tty);
		fprintf(stderr, "addr: %d ", request.addr.sa_family);
		for(i=0;i<14;i++) fprintf(stderr, "%d ", request.addr.sa_data[i]);
		fprintf(stderr, "\n");
		fprintf(stderr, "ctl_addr: %d ", request.ctl_addr.sa_family);
		for(i=0;i<14;i++) fprintf(stderr, "%d ", request.ctl_addr.sa_data[i]);
		fprintf(stderr, "\n");
#endif
		process_request(&request, &response);
		udp_hdr.size = sizeof(response);
#if 0
		fprintf(stderr, "talk vers %d  type %d    id %ld\n",
			response.vers, response.type, response.id_num);
		fprintf(stderr, "Answer %d\n", response.answer);
		fprintf(stderr, "addr: %d ", response.addr.sa_family);
		for(i=0;i<14;i++) fprintf(stderr, "%d ", response.addr.sa_data[i]);
		fprintf(stderr, "\n");
	fprintf(stderr, "UDP HEADER WRITE\n");
	fprintf(stderr, "size = %d\n", udp_hdr.size);
	fprintf(stderr, "lsocket: %ld %d\n", udp_hdr.lsocket.address, udp_hdr.lsocket.port);
	fprintf(stderr, "fsocket: %ld %d\n", udp_hdr.fsocket.address, udp_hdr.fsocket.port);
#endif
		s = write(netout, &udp_hdr, sizeof(struct udp_hdr));
		s = write(netout, &response, udp_hdr.size);
	}
   }
   fprintf(stderr, "talkd: closing\n");
   close(netin); close(netout);
}
