/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		TNET "TCP" module setup commands.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "netcom.h"


_PROTOTYPE( void tcpusage, (int what)					);
_PROTOTYPE( void tcp_mss, (int argc, char **argv)			);
_PROTOTYPE( void tcp_window, (int argc, char **argv)			);


static struct _cmd_ {
  char	*name;
  void	(*func)();
} commands[] = {
  { "mss",	tcp_mss		},
  { "window",	tcp_window	},
  { "",		0		}
};


/* Show some help on the IP commands. */
static void tcpusage(what)
int what;
{
  printf("Usage: tcp ");
  if (what < 0 || what == 0) printf("mss [value]\n");
  if (what < 0 || what == 1) printf("           window [value]\n");
  printf("\n");
}


/* Perform the "tcp mss" command. */
static void tcp_mss(argc, argv)
int argc;
char *argv[];
{
  RMTHDR hdr;
  int st, netin;

  hdr.c_opcode = RMT_TCP;
  hdr.c_length = 0;
  hdr.c_i1 = TCPVAL_MSS;

  if (argc == 0) {
	hdr.c_i2 = 0;
	st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
	if (st < 0) return;
	(void) close(netin);
	st = hdr.c_opcode;
	if (st != 0) printf("TCP MSS failed; error code is %d\n", st);
	  else printf("TCP MSS: %d\n", hdr.c_i2);
  } else {
	if (argc != 1) {
		tcpusage(1);
		return;
	}
	hdr.c_i2 = atoi(argv[0]);
	st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
	if (st < 0) return;
	(void) close(netin);
	st = hdr.c_opcode;
	if (st != 0) printf("TCP MSS failed; error code is %d\n", st);
  }
}


/* Perform the "tcp window" command. */
static void tcp_window(argc, argv)
int argc;
char *argv[];
{
  RMTHDR hdr;
  int st, netin;

  hdr.c_opcode = RMT_TCP;
  hdr.c_length = 0;
  hdr.c_i1 = TCPVAL_WINDOW;

  if (argc == 0) {
	hdr.c_i2 = 0;
	st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
	if (st < 0) return;
	(void) close(netin);
	st = hdr.c_opcode;
	if (st != 0) printf("TCP WINDOW failed; error code is %d\n", st);
	  else printf("TCP WINDOW: %d\n", hdr.c_i2);
  } else {
	if (argc != 1) {
		tcpusage(1);
		return;
	}
	hdr.c_i2 = atoi(argv[0]);
	st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
	if (st < 0) return;
	(void) close(netin);
	st = hdr.c_opcode;
	if (st != 0) printf("TCP WINDOW failed; error code is %d\n", st);
  }
}


/* Perform the "tcp..." command line. */
int do_tcp(argc, argv)
int argc;
char **argv;
{
  char buff[128];
  register int i;

  if (argc == 0) {
	tcpusage(-1);
	return(-1);
  }

  /* See which command this is. */
  i = 0;
  while (commands[i].name[0] != '\0') {
	if (!strcmp(commands[i].name, argv[0])) break;
	i++;
  }
  if (commands[i].name[0] != '\0') {
	(*commands[i].func)(--argc, &argv[1]);
  } else tcpusage(-1);
  return(0);
}
