/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		TNET STAT command.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *              Michael Temari, <temari@temari.ae.ge.com>
 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "netcom.h"


_PROTOTYPE( void stusage, (int)						);
_PROTOTYPE( void st_dump, (int)						);


static void stusage(what)
int what;
{
  printf("Usage: stat [tcb block]");
  printf("\n");
}


static void st_dump(tcb)
int tcb;
{
  char buff[128];
  RMTHDR hdr;
  int st, netin;

  /* Tell TNET to do a stat command. */
  hdr.c_opcode = RMT_STAT;
  hdr.c_length = 0;
  hdr.c_i1 = STAT_DUMP;
  hdr.c_i2 = tcb;

  st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
  if (st < 0) {
	printf("stat dump: error code %d\n\n", st);
	return;
  }
  if (hdr.c_opcode == 0) {
	while(1) {
		st = read(netin, buff, 128);
		if (st > 0) (void) write(1, buff, st);
		  else break;
	}
  } else printf("Error code: %d\n\n", hdr.c_opcode);
  (void) close(netin);
}


int do_stat(argc, argv)
int argc;
char **argv;
{
  int st;
  int tcb;

  if (argc > 1) {
	stusage(-1);
	st = EINVAL;
	return(st);
  } else {
	if(argc == 1)
		tcb = atoi(argv[0]);
	else
		tcb = 0;
	st_dump(tcb);  
	return(0);
  }
}
