/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		TNET IP Routing Table management.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "netcom.h"


_PROTOTYPE( void rtusage, (int)						);
_PROTOTYPE( void rt_dump, (void)					);
_PROTOTYPE( int rt_add, (int, char **)					);
_PROTOTYPE( int rt_drop, (int, char **)					);


static void rtusage(what)
int what;
{
  printf("Usage: route ");
  if (what < 0 || what == 0)
	printf("add destination iface [gateway [metric]]\n");
  if (what < 0 || what == 1)
	printf("drop destination\n");
  printf("\n");
}


static void rt_dump()
{
  char buff[128];
  RMTHDR hdr;
  int st, netin;

  /* Tell TNET to dump its routing table. */
  hdr.c_opcode = RMT_ROUTE;
  hdr.c_length = 0;
  hdr.c_i1 = ROUTE_DUMP;

  st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
  if (st < 0) {
	printf("route dump: error code %d\n\n", st);
	return;
  }
  if (hdr.c_opcode == 0) {
	while(1) {
		st = read(netin, buff, 128);
		if (st > 0) (void) write(1, buff, st);
		  else break;
	}
  } else printf("Error code: %d\n\n", hdr.c_opcode);
  (void) close(netin);
}


static int rt_add(argc, argv)
int argc;
char *argv[];
{
  RMTHDR hdr;
  struct uroute rt;
  struct hostent *hp;
  int st, netin;

  if (argc < 2) {
	rtusage(0);
	return(-1);
  }

  /* Resolve the "destination" address. */
  if (strcmp(argv[0], "default")) {
	hp = gethostbyname(argv[0]);
	if (hp == (struct hostent *)NULL) {
		printf("route add: unknown host %s\n\n", argv[0]);
		return(-1);
	}
	memcpy((char *) &rt.target, (char *) hp->h_addr, hp->h_length);
  } else rt.target = (u_long) 0;

  /* Set the interface name for this route. */
  strncpy(rt.iface, argv[1], 16);

  argc -= 2;
  if (argc > 0) {
	/* Resolve the "gateway" address. */
	hp = gethostbyname(argv[2]);
	if (hp == (struct hostent *)NULL) {
		printf("route add: unknown gateway %s\n\n", argv[2]);
		return(-1);
	}
	memcpy((char *) &rt.gateway, (char *) hp->h_addr, hp->h_length);

	/* Set the "gateway metric" value. */
	if (--argc > 0) {
		rt.metric = atoi(argv[3]);
	} else rt.metric = 0;
  } else {
	rt.gateway = (u_long) 0;
	rt.metric = 0;
  }

  if (argc != 0) {
	rtusage(0);
	return(-1);
  }

  /* Now, tell TNET about this new route. */
  hdr.c_opcode = RMT_ROUTE;
  hdr.c_length = sizeof(struct uroute);
  hdr.c_i1 = ROUTE_ADD;

  st = tn_rlink(&hdr, (char *) &rt, 0, 10, &netin);
  if (st < 0) {
	printf("route add: error code %d\n\n", st);
	return(st);
  }

  (void) close(netin);
  if (hdr.c_opcode != 0) printf("Error code: %d\n\n", hdr.c_opcode);
  return(hdr.c_opcode);
}


static int rt_drop(argc, argv)
int argc;
char *argv[];
{
  RMTHDR hdr;
  struct hostent *hp;
  int st, netin;

  if (argc != 1) {
	rtusage(1);
	return(-1);
  }

  hdr.c_opcode = RMT_ROUTE;
  hdr.c_length = 0;
  hdr.c_i1 = ROUTE_DROP;

  /* Resolve the "destination" address. */
  if (strcmp(argv[0], "default")) {
	hp = gethostbyname(argv[0]);
	if (hp == (struct hostent *)NULL) {
		printf("route drop: unknown host %s\n\n", argv[0]);
		return(-1);
	}
	memcpy((char *) &hdr.c_l1, (char *) hp->h_addr, hp->h_length);
  } else hdr.c_l1 = (u_long) 0;

  st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
  if (st < 0) {
	printf("route drop: error code %d\n\n", st);
	return(st);
  }
  (void) close(netin);
  if (hdr.c_opcode != 0) printf("Error code: %d\n\n", hdr.c_opcode);
  return(hdr.c_opcode);
}


int do_route(argc, argv)
int argc;
char **argv;
{
  int st;

  if (argc != 0) {
	if (!strcmp(argv[0], "add")) st = rt_add(--argc, ++argv);
	  else if (!strcmp(argv[0], "drop")) st = rt_drop(--argc, ++argv);
	  else {
		rtusage(-1);
		st = EINVAL;
	}
	return(st);
  } else {
	rt_dump();  
	return(0);
  }
}
