/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		TNET "IP" module setup commands.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "netcom.h"


_PROTOTYPE( void ipusage, (int what)					);
_PROTOTYPE( void ip_addr, (int argc, char *argv[])			);
_PROTOTYPE( void ip_ttl, (int argc, char *argv[])			);


static struct _cmd_ {
  char	*name;
  void	(*func)();
} commands[] = {
  { "addr",	ip_addr		},
  { "ttl",	ip_ttl		},
  { "",		0		}
};


/* Show some help on the IP commands. */
static void ipusage(what)
int what;
{
  printf("Usage: ip ");
  if (what < 0 || what == 0) printf("addr [address|name]\n");
  if (what < 0 || what == 0) printf("          ttl [value]\n");
  printf("\n");
}


/* Perform the "ip addr" command. */
static void ip_addr(argc, argv)
int argc;
char *argv[];
{
  u_long my_addr;
  struct hostent *hp;

  if (argc == 0) {
	my_addr = gethostid();
	printf("IP Address: %s\n", inet_ntoa(my_addr));
  } else {
	if (argc != 1) {
		ipusage(0);
		return;
	}
	hp = gethostbyname(argv[0]);
	if (hp == (struct hostent *)NULL) {
		printf("IP ADDR: unknown host %s\n", argv[0]);
		return;
	}
	if (opt_d == 1) printf("Host: %s\n", hp->h_name);
	memcpy((char *) &my_addr, hp->h_addr, hp->h_length);
	(void) sethostid(my_addr);
  }
}


/* Perform the "ip ttl" command. */
static void ip_ttl(argc, argv)
int argc;
char *argv[];
{
  RMTHDR hdr;
  int st, netin;

  hdr.c_opcode = RMT_IP;
  hdr.c_length = 0;
  hdr.c_i1 = IPVAL_TTL;

  if (argc == 0) {
	hdr.c_i2 = 0;
	st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
	if (st < 0) return;
	(void) close(netin);
	st = hdr.c_opcode;
	if (st != 0) printf("IP TTL failed; error code is %d\n", st);
	  else printf("IP TTL: %d\n", hdr.c_i2);
  } else {
	if (argc != 1) {
		ipusage(1);
		return;
	}
	hdr.c_i2 = atoi(argv[0]);
	st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
	if (st < 0) return;
	(void) close(netin);
	st = hdr.c_opcode;
	if (st != 0) printf("IP TTL failed; error code is %d\n", st);
  }
}


/* Perform the "ip ..." command line. */
int do_ip(argc, argv)
int argc;
char **argv;
{
  char buff[128];
  register int i;
  register char **sp;

  if (argc == 0) {
	ipusage(-1);
	return(-1);
  }

  /* See which command this is. */
  i = 0;
  while (commands[i].name[0] != '\0') {
	if (!strcmp(commands[i].name, argv[0])) break;
	i++;
  }
  if (commands[i].name[0] != '\0') {
	(*commands[i].func)(--argc, &argv[1]);
  } else ipusage(-1);
  return(0);
}
