/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file contains an implementation of the "server"
 *		for the FINGER protocol.  This protocol can be used to
 *		access user information databases.
 *
 * NOTE:	Since MINIX does not (yet) handle "TTY Idle" times, we
 *		cannot display this in this program. Also, the login
 *		program does not have the "-h" option, so no "Where"
 *		field can be displayed.
 *
 * Usage:	fingerd [-dv]
 *
 * Version:	@(#)fingerd.c	1.00	07/02/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <utmp.h>
#include <stdio.h>


static char *Version = "@(#) fingerd 1.00 (07/02/92)";


int opt_d = 0;				/* debugging output flag	*/


extern int getopt(), optind, opterr;
extern char *optarg;


/*
 * Scan though the current "/etc/utmp" file, and see who's logged
 * in.  Of each logged-in user, display some more detailed info.
 * This code has been "slightly" inspired by my "who.c" program.
 */
void do_list()
{
  char buff[64];
  struct utmp utmp;
  struct stat stb;
  struct tm *tm;
  struct passwd *pw;
  time_t login;
  int found, size, fd;
  char *idle, *where;
  char *message;

  size = sizeof(struct utmp);
  found = 0;
  if ((fd = open(UTMP, O_RDONLY)) < 0) {
	printf("This system does not have user-accounting!\r\n");
	return;
  }
  while (read(fd, &utmp, size) == size) {
	if (utmp.ut_type != USER_PROCESS) continue;
	if (found == 0) {
		found++;
		printf("Login    Name                     ");
		printf("TTY          Idle   When     Where\r\n");
	}

	pw = getpwnam(utmp.ut_name);

	sprintf(buff, "/dev/%s", utmp.ut_line);
	if (stat(buff, &stb) == 0) {
		if (stb.st_mode & (S_IWGRP | S_IWOTH)) message = " ";
		  else message = "*";
	} else message = "?";

	login = utmp.ut_time;
	tm = localtime(&login);
	sprintf(buff, "%02.2d:%02.2d:%02.2d",
		tm->tm_hour, tm->tm_min, tm->tm_sec);

	idle = "";	/* to be implemented in MINIX :-( */
	where = "";	/* to be implemented in login(1) */

	printf("%-8.8s %-24.24s %-12.12s %s%-4.4s  %-8.8s %s\r\n",
		utmp.ut_name,
		(pw == (struct passwd *)NULL) ? "?????" : pw->pw_gecos,
		utmp.ut_line, message, idle, buff, where);
  }
  (void) close(fd);
  if (found == 0) printf("No one logged on.\r\n");
}


/* Answer an incoming FINGER request. */
int fingerd()
{
  char request[128];
  register char *sp;
  struct passwd *pw;

  (void) fgets(request, 128, stdin);
  if ((sp = strchr(request, '\r')) != (char *)NULL) *sp = '\0';
  if ((sp = strchr(request, '\n')) != (char *)NULL) *sp = '\0';
  sp = request;

  /*
   * If the caller sent us a blank like, it wants to see a list of
   * all active users.  Otherwise, we can expect the line to hold
   * the name (in ASCII) of the user the caller wants to see.
   */
  if (*sp != '\0') {
	pw = getpwnam(sp);
	if (pw != (struct passwd *)NULL) {
		printf("\r\nLogin name    : %s (uid=%d gid=%d)\r\n",
				pw->pw_name, pw->pw_uid, pw->pw_gid);
		printf("In real life  : %s\r\n", pw->pw_gecos);
		printf("Home directory: %s\r\nShell         : %s\r\n",
						pw->pw_dir, pw->pw_shell);
		printf("\r\n");
	} else printf("\r\nUser %s is not known at this host.\r\n", sp);
  } else do_list();

  return(0);
}


void usage()
{
  fprintf(stderr, "Usage: fingerd [-dv]\n");
  exit(-1);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char who[128];
  register int c;

  opterr = 0;
  while ((c = getopt(argc, argv, "dv")) != EOF) switch(c) {
	case 'd':
	case 'v':
		opt_d = 1;
		break;
	default:
		usage();
  }

  /* No more arguments allowed. */
  if (optind != argc) usage();

  /* Start the server. */
  c = fingerd();

  return(c);
}
