#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <sgtty.h>
#include <errno.h>
int p1, p2, fd;

#define	KEYBOARD	"/dev/tty"
static	struct sgttyb	oldsgttyb;	/* original terminal modes */

int
OpenKeyboard()
{
	struct sgttyb	newsgttyb;	/* new terminal modes */

	fd = open(KEYBOARD, O_RDONLY  + O_NONBLOCK );
	if (fd < 0)
		return -1;

	if (ioctl(fd, TIOCGETP, &oldsgttyb) < 0) {
		close(fd);
		fd = 0;
		return -1;
	}

	newsgttyb = oldsgttyb;
	newsgttyb.sg_flags |= RAW;
	newsgttyb.sg_flags &= ~(EVENP | ODDP | ECHO | XTABS | CRMOD);
	if (ioctl(fd, TIOCSETP, &newsgttyb) < 0) {
		close(fd);
		fd = 0;
		return -1;
	}
	return 0;
}

/*
 * Close the keyboard.
 * This resets the terminal modes.
 */
void
CloseKeyboard()
{
	ioctl(fd, TIOCSETP, &oldsgttyb);
	close(fd);
	fd = 0;
}


int
ReadKeyboard(buf)
	char		*buf;		/* data character */
{
	int	cc;			/* characters read */

	cc = read(fd, buf, 1);
	if (cc > 0)
		return 1;
	if ((cc < 0) && (errno != EINTR) && (errno != EAGAIN))
		return -1;
	return 0;
}


void main()
{
char str[500];
struct sgttyb args;
int d, c;

	OpenKeyboard();
	p1 = open("/dev/ptyp0", O_RDWR + O_NONBLOCK);
	if (p1 < 0) goto end;
	args.sg_ispeed = args.sg_ospeed = B9600;
	if(ioctl(p1, TIOCSETP, &args) < 0) printf("cann't ioctl \n");
	while(1)
	{
		if (ReadKeyboard(&c) == 1) {
			if (c == '') goto end;
			/* else if (c == '#') ; */
			else  write(p1, &c, 1);
		}
		d = read(p1, str, 500);
		if (d > 0) {
			write(1, str, d);
		}
	}
end:
	args.sg_ispeed = args.sg_ospeed = B0;
	if(ioctl(p1, TIOCSETP, &args) < 0) printf("cann't ioctl \n");
	close(p1);
	CloseKeyboard();
	exit(0);

}
