#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <limits.h>
#include <sgtty.h>
#include <string.h>
#include <unistd.h>

#define FORWARD		static
#define PRIVATE		static
#define PUBLIC

#define CONSNAME	"/dev/tty0"	/* system console device */

#define SHELL1		"/bin/sh"
#define SHELL2		"/usr/bin/sh"

#define EXIT_TTYFAIL	253		/* child had problems with tty */
#define EXIT_EXECFAIL	254		/* child couldn't exec something */
#define EXIT_OPENFAIL	255		/* child couldn't open something */


extern char **environ;			/* declaration required by library routines */

char *CONSOLE = CONSNAME;	/* name of system console */
struct sgttyb args;		/* buffer for TIOCGETP */
int gothup = 0;			/* flag, showing signal 1 was recieved */
int pidct = 0;			/* count of running children */

char *env[] = { (char *)0 };	/* tiny environment for execle */

PUBLIC int main()
{
  int pid;			/* pid of child process */
  int fd;			/* fd of console for error messages */
  int i;			/* loop variable */
  int status;			/* return status from child process */
  char *line[50];

  sync();			/* force buffers out onto disk */

  
  printf("line ?\n");
  scanf("%s", line);

  if( (pid = fork()) != 0 ) {
	/* Parent */
  } else {
	/* Child */
	close(0);				/* just in case */
	close(1);				/* just in case */
	close(2);				/* just in case */

	if( open(line, O_RDWR) != 0 ) _exit(EXIT_TTYFAIL);  /* standard input */
	if(	   dup(0) != 1 ) _exit(EXIT_TTYFAIL);	/* standard output */
	if( 	   dup(1) != 2 ) _exit(EXIT_TTYFAIL);	/* standard error */
	write(1, "starting sh\n", 12);
	write(2, "error of sh\n", 12);

	/* Set line parameters. */

	if(ioctl(0, TIOCGETP, &args) < 0) _exit(EXIT_TTYFAIL);
	args.sg_ispeed = args.sg_ospeed = B9600;
	args.sg_flags = BITS8 | ECHO | XTABS | CRMOD;
	if(ioctl(0, TIOCSETP, &args) < 0) _exit(EXIT_TTYFAIL);

	execle(SHELL1, SHELL1, (char *)0, env);
	execle(SHELL2, SHELL2, (char *)0, env);

	_exit(EXIT_EXECFAIL);
  }
}



