/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		The TNET 'gethostid(2)' call.
 *
 * Version:	@(#)tnet/ghid.c		1.00		07/11/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


u_long gethostid()
{
  RMTHDR hdr;
  int s, fd;

  /* Setup client command request */
  hdr.c_opcode = RMT_GHID;
  hdr.c_length = 0;

  /* Let tn_rlink() to the ugly work... */
  s = tn_rlink(&hdr, (char *)NULL, 0, 10, &fd);
  if (s != 0) return(s);

  /* Check the TNET result code. */
  if (hdr.c_opcode != 0) return((u_long) hdr.c_opcode);

   /* We no longer need the upcall channel. */
  (void) close(fd);
  return((u_long) hdr.c_l1);
}
