/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 * Version:	@(#)tnet/gdname.c	1.00		07/11/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


int getdomainname(bufp, buflen)
char *bufp;
int buflen;
{
  RMTHDR hdr;
  int s, fd;

  /* Setup client command request */
  hdr.c_opcode = RMT_GDNAME;
  hdr.c_length = 0;

  /* Let tn_rlink() to the ugly work... */
  s = tn_rlink(&hdr, bufp, buflen, 10, &fd);
  if (s != 0) return(s);

  /* Check the TNET result code. */
  if (hdr.c_opcode != 0) return(hdr.c_i1);

   /* We no longer need the upcall channel. */
  (void) close(fd);
  return(s);
}
