/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file takes care of communicating with the TNET
 *		kernel.  It is something like the BSD "socket" call,
 *		since it makes the actual connection...
 *
 * Version:	@(#)tnet/client.c	1.10		07/11/92
 *
 * Authors:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Michael Temari, <temari@temari.ae.ge.com>
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


int tconnect(protocol, lport, port, ipaddr, flags, netin, netout)
int protocol;
u_short *lport;
u_short *port;
u_long *ipaddr;
u_long flags;
int *netin, *netout;
{
  char buff[128];
  RMTHDR hdr;
  int s, fd;

  /* Setup client command request */
  hdr.c_opcode = RMT_CONNECT;
  hdr.c_length = 0;
  hdr.c_i1 = protocol;
  hdr.c_i2 = *port;
  hdr.c_i3 = *lport;
  hdr.c_l1 = (long) *ipaddr;
  hdr.c_l2 = (long) flags;

  /* Let tn_rlink() to the ugly work... */
  s = tn_rlink(&hdr, (char *)NULL, 0, 60, netin);
  if (s != 0) return(s);

  /* Check the TNET result code. */
  if (hdr.c_opcode != 0) return(hdr.c_opcode);

  /* OK, so open up my WRITE channel to TNET. */
  sprintf(buff, "%s/%s/%s", TNET_DIR, TNET_PDIR, hdr.c_return);
  if ((fd = open(buff, O_WRONLY)) < 0) return(errno);

  /* Stash the file descriptor. */
  if (netout != (int *)NULL) *netout = fd;

  /* Stash the ports and address. */
  *port   = hdr.c_i2;
  *lport  = hdr.c_i3;
  *ipaddr = hdr.c_l1;

  /* And finally, remove the file (it will live on "In Limbo". */
  (void) unlink(buff);

  return(0);
}


int client(protocol, lport, port, ipaddr, netin, netout)
int protocol;
u_short lport;
u_short port;
u_long ipaddr;
int *netin, *netout;
{
  return(tconnect(protocol, &lport, &port, &ipaddr, 1L, netin, netout));
}
