/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Convert network-format internet addresses to "dotted
 *		decimal ASCII" (i.e. base 256 d.d.d.d) representation.
 *
 * Version:	@(#)inet/in_ntoa.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <arpa/inet.h>
#include <inet/in.h>


#define	UC(b)	(((int)b)&0xff)


char *inet_ntoa(in)
u_long in;
{
  static char b[18];
  register char *p;

  p = (char *) &in;
  sprintf(b, "%d.%d.%d.%d", UC(p[0]), UC(p[1]), UC(p[2]), UC(p[3]));
  return(b);
}
