/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Internet network address interpretation routine. The
 *		library routines call this routine to interpret
 *		network numbers.
 *
 * Version:	@(#)inet/in_network.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <arpa/inet.h>
#include <inet/in.h>
#include <ctype.h>


u_long inet_network(cp)
register char *cp;
{
  register u_long val, base, n;
  register char c;
  u_long parts[4], *pp = parts;
  register int i;

again:
  val = 0; base = 10;
  if (*cp == '0') base = 8, cp++;
  if (*cp == 'x' || *cp == 'X') base = 16, cp++;
  while (c = *cp) {
	if (isdigit(c)) {
		val = (val * base) + (c - '0');
		cp++;
		continue;
	}
	if (base == 16 && isxdigit(c)) {
		val = (val << 4) + (c + 10 - (islower(c) ? 'a' : 'A'));
		cp++;
		continue;
	}
	break;
  }
  if (*cp == '.') {
	if (pp >= parts + 4) return(INADDR_NONE);
	*pp++ = val, cp++;
	goto again;
  }
  if (*cp && !isspace(*cp)) return(INADDR_NONE);
  *pp++ = val;
  n = pp - parts;
  if (n > 4) return(INADDR_NONE);
  for (val = 0, i = 0; i < n; i++) {
	val <<= 8;
	val |= parts[i] & 0xff;
  }
  return(val);
}
