/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file handles the conversion of Internet addresses
 *		in (dotted decimal) ASCII notation to binary form. The
 *		returned values are in Network Byte Order.
 *
 * Version:	@(#)inet/in_addr.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <ctype.h>
#include <arpa/inet.h>
#include <inet/in.h>


u_long inet_addr(cp)
register char *cp;
{
  struct in_addr val;

  if (inet_aton(cp, &val)) return(val.s_addr);
  return((u_long)0L);
}


/* 
 * Check whether "cp" is a valid ascii representation
 * of an Internet address and convert to a binary address.
 * Returns 1 if the address is valid, 0 if not.
 * This replaces inet_addr, the return value from which
 * cannot distinguish between failure and a local broadcast address.
 */
int inet_aton(cp, addr)
register char *cp;
struct in_addr *addr;
{
  register u_long val, base;
  register char c;
  register int n;
  u_long parts[4], *pp = parts;

  for (;;) {
	/*
	 * Collect number up to ``.''.
	 * Values are specified as for C:
	 * 0x=hex, 0=octal, other=decimal.
	 */
	val = 0; base = 10;
	if (*cp == '0') {
		if (*++cp == 'x' || *cp == 'X') base = 16, cp++;
		  else base = 8;
	}
	while ((c = *cp) != '\0') {
		if (isascii(c) && isdigit(c)) {
			val = (val * base) + (c - '0');
			cp++;
			continue;
		}
		if (base == 16 && isascii(c) && isxdigit(c)) {
			val = (val << 4) + (c + 10 - (islower(c) ? 'a' : 'A'));
			cp++;
			continue;
		}
		break;
	}
	if (*cp == '.') {
		/*
		 * Internet format:
		 *	a.b.c.d
		 *	a.b.c	(with c treated as 16-bits)
		 *	a.b	(with b treated as 24 bits)
		 */
		if (pp >= parts + 3 || val > 0xff) return(0);
		*pp++ = val, cp++;
	} else break;
  }

  /*
   * Check for trailing characters.
   */
  if (*cp && (!isascii(*cp) || !isspace(*cp))) return (0);

  /*
   * Concoct the address according to the number of parts specified.
   */
  n = (int) (pp - parts + 1);
  switch (n) {
	case 1:				/* a -- 32 bits */
		break;
	case 2:				/* a.b -- 8.24 bits */
		if (val > 0xffffff) return (0);
		val |= parts[0] << 24;
		break;
	case 3:				/* a.b.c -- 8.8.16 bits */
		if (val > 0xffff) return (0);
		val |= (parts[0] << 24) | (parts[1] << 16);
		break;
	case 4:				/* a.b.c.d -- 8.8.8.8 bits */
		if (val > 0xff) return (0);
		val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);
		break;
  }
  if (addr) addr->s_addr = htonl(val);
  return(1);
}
