/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file handles the errors associated with INET
 *		software.
 *
 * Version:	@(#)inet/herror.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */


char *h_errlist[] = {
  "Error 0",
  "Unknown host",			/* 1 HOST_NOT_FOUND		*/
  "Host name lookup failure",		/* 2 TRY_AGAIN			*/
  "Unknown server error",		/* 3 NO_RECOVERY		*/
  "No address associated with name",	/* 4 NO_ADDRESS			*/
};
int h_nerr = sizeof(h_errlist)/sizeof(h_errlist[0]);


extern int	h_errno;


/* herror -- print the error indicated by the h_errno value. */
void herror(s)
char *s;
{
  char buff[128];
  char *sp;

  if (s && *s) {
	strcpy(buff, s);
	strcat(buff, ": ");
  }
  sp = h_errno < h_nerr ? h_errlist[h_errno] : "Unknown error";
  strcat(buff, sp);
  strcat(buff, "\n");

  write(2, buff, strlen(buff));
}
