/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Various definitions for the 'software timers' module.
 *
 * Version:	@(#)timer.h		1.00	07/02/92
 *
 * Authors:	Original by Phil Karn KA9Q.
 *		Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */

struct timer {
	struct timer *next;	/* Doubly-linked-list pointers */
	struct timer *prev;
	int16 start;		/* Period of counter (load value) */
	int16 count;		/* Ticks to go until expiration */
	void (*func)();		/* Function to call at expiration */
	int *arg;		/* Arg to pass function */
	char state;		/* Timer state */
#define	TIMER_STOP	0
#define	TIMER_RUN	1
#define	TIMER_EXPIRE	2
};
#define	NULLTIMER	(struct timer *)NULL
#define	MAX_TIME	(int16)65535	/* Max short integer */
#define	MSPTICK		1000		/* Milliseconds per tick */
/* Useful user macros that hide the timer structure internals */
#define	set_timer(t,x)	(((t)->start) = (x)/MSPTICK)
#define	dur_timer(t)	((t)->start)
#define	read_timer(t)	((t)->count)
#define	run_timer(t)	(((t)->state == TIMER_RUN) ? 1 : 0)
