/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		TCP timeout routines.
 *
 * Version:	@(#)tcptimer.c		1.00	07/08/92
 *
 * Authors:	Original by Phil Karn KA9Q.
 *		Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include "tnet.h"

#include <stdio.h>

#include "timer.h"
#include "mbuf.h"
#include "netuser.h"
#include "ip.h"
#include "tcp.h"

/* Timer timeout */
void
tcp_timeout(arg)
int *arg;
{
	register struct tcb *tcb;

	tcb = (struct tcb *)arg;
	switch(tcb->state){
	case TIME_WAIT:		/* 2MSL timer has expired */
		close_self(tcb,NORMAL);
		break;
	default:		/* Retransmission timer has expired */
		if(tcb->retry < RETRY){
			tcb->retry++;
			tcb->backoff = min(tcb->backoff+1,BACKOFF);
			tcb->snd.ptr = tcb->snd.una;
			/* RTT is always measured from the FIRST transmission
			 * of a given sequence number, because in TCP there
			 * is no way to tell which (re)transmission a given
			 * ACK is for. This errs on the long (conservative)
			 * side when the path is lossy.
			 */
			tcb->rtt += tcb->timer.start;
			tcp_output(tcb);
		} else {
			/* Give up */
			close_self(tcb,TIMEOUT);
		}
	}
}
