/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		The main file of the TNET kernel program.
 *
 * Version:	@(#)main.c		1.00	07/12/92
 *
 * Authors:	Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include "tnet.h"

#include <signal.h>
#include <unistd.h>
#include <stdio.h>

#include "rmt.h"
#include "iface.h"
#include "inetd.h"
#include "netuser.h"
#include "nproc.h"

#ifndef	_NSIG
#   ifdef NSIG
#	define	_NSIG	NSIG
#   else
#	define	_NSIG	0
#   endif
#endif


#define VERSION		"3.00"


extern struct interface if_lo;
struct interface *ifaces = &if_lo;


int shutdown = FALSE;
int debug = 0;


_PROTOTYPE( void closenet, (void)					);
_PROTOTYPE( void Hang_up, (void)					);
_PROTOTYPE( void usage, (void)						);


static void closenet()
{
  struct interface *ifp;

  rmtstop();

  for (ifp = ifaces; ifp != NULLIF; ifp = ifp->next)
	if (ifp->stop != NULLFP) (*ifp->stop)(ifp);

  rprintf(2, "\nNet stopped\n");
}


static void Hang_up()
{
  rprintf(2, "Closing because of hangup\n");
  closenet();
  (void) kill(getpid(), SIGKILL);	/* suicide */
}


static void usage()
{
  rprintf(2, "Usage: tnet [-d] ip_address\n");
  exit(-1);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char buff[128];
  extern int optind;
  extern char *optarg;
  int c, i, fdin;
  FILE *initfp;
  int16 clkval;
  struct interface *ifp;
  extern void config();		/* FIXME */

  for(i = 1; i <= _NSIG; i++)
	signal(SIGHUP, Hang_up);

  /* Parse command line arguments */
  while((c = getopt(argc,argv,"d")) != EOF) {
	switch(c) {
		case 'd':
			debug = 1 - debug;
			break;
		default:
			usage();
	}
  }

  /*
   * This block of code should disappear when we are completely
   * "system call" based.  This will eliminate the need for the
   * ASCII configuration file, and this command-line based option
   * to set the IP address.
   */
  {
	/* Exactly one argument required. */
	if (optind != (argc - 1)) usage();

	/* Fetch our IP address from the command line. */
	ip_addr = ntohl(inet_addr(argv[optind]));
	if (ip_addr == (long) -1) usage();

	/* Add a route to this address. */
	for(ifp = ifaces; ifp != NULLIF; ifp = ifp->next)
		if(strcmp(ifp->name, "loopback") == 0) break;
	if (ifp != NULLIF) rt_add(ip_addr, 0L, 0, ifp);
  }

  rprintf(2, "KA9Q NET Copyright Phil Karn KA9Q\n");
  rprintf(2, "TNET version %s, by Michael Temari and Fred N. van Kempen\n\n",
								VERSION);
  {
	rprintf(2, "IP Address: %s\n\n", inet_ntoa(htonl(ip_addr)));
  }

  initnproc();			/* initialize the NPROC module		*/
  rmtinit();			/* initialize the RMT module		*/
  inetd();			/* initialize the INETD module		*/
  clkval = clksec();		/* initialize the TIMER module		*/
#ifdef NOTDEF
  (void) close(0);		/* close the TNET stdin			*/
  (void) close(1);		/* close the TNET stdout		*/
#endif

  /* This is the main TNET server loop. */
  while(!shutdown) {

	/* Check on any system call requests. */
	DOrmt();

	/* Service the active I/O channels for the servers. */
	DOnproc();

	/* Service the interfaces. */
	for (ifp = ifaces; ifp != NULLIF; ifp = ifp->next)
		if (ifp->recv != NULLFP) (*ifp->recv)(ifp);

	/* Service the clock if it has ticked. */
	if (clkval != clksec()) {
		clkval = clksec();
		tick();
		(void) iss();
	}
  }
  closenet();
}
