/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Various definitions for the ETH interface.
 *
 * Version:	@(#)eth.h		1.00	07/07/92
 *
 * Authors:	Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */

#define	EC_MAX		1	/* number of allowed ETH interfaces	*/

/* Format of an Ethernet header. */
struct ether {
  char dest[6];
  char source[6];
  int16 type;
};

/* Ethernet type fields */
#define	IP_TYPE		0x800	/* type field for IP			*/
#define	ARP_TYPE	0x806	/* type field for ARP			*/
 
#define SIZE_ADDR	6	/* size of Hardware address		*/

#if HAVE_ETHER
extern char myethad[6];
#endif


_PROTOTYPE( eth_attch, (struct interface *ifa)				);
_PROTOTYPE( void pether, (char *outbuf, char *addr)			);
