/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Definitions for the BSD Socket interface definitions.
 *
 * Version:	@(#)inet/socket.h	1.00		07/02/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#ifndef _INET_SOCKET_H
#define _INET_SOCKET_H

#include <arpa/internet.h>

/* TCP/IP address family types. */
#define	AF_LOCAL		0
#define	AF_UNIX			1
#define	AF_INET			2

/* Socket I/O types. */
#define	SOCK_STREAM		0
#define	SOCK_DGRAM		1
#define	SOCK_RAW		2

/* TCP/IP related error codes. */
#define	ESOCKTNOSUPPORT		201
#define	EAFNOSUPPORT		202
#define	EOPNOTSUPP		203
#define	ENOTCONN		204
#define	ECONNREFUSED		205
#define EAFNOSUPP		206
#define	EISCONN			207
#define	EWOULDBLOCK		208
#define	EADDRINUSE		209
#define EMSGSIZE		210
#define	EALARM			211
#define	EABORT			212

/* Generic socket address structure. */
struct sockaddr {
  u_short	sa_family;
  char		sa_data[14];
};
#define	SOCKSIZE	(sizeof(struct sockaddr))
#define MAXSOCKSIZE	SOCKSIZE

/* MINIX cannot handle BSD-ish long names. */
#if _MINIX
#   define getdomainname	gdname
#   define gethostid		ghostid
#   define gethostname		ghname
#   define getpeername		gpname
#   define getsockname		gsname
#   define setdomainname	sdname
#   define sethostid		shostid
#   define sethostname		shname
#   define send			socksend	/* MINIX IPC !!!! */
#   define recv			sockrecv
#endif

/* Function prototyping according to ANSI. */
#ifndef _PROTOTYPE
#    if _MINIX
#	include <ansi.h>
#    else
#	define _ANSI		0
#	ifdef __STDC__		
#	    if (__STDC__ == 1)	
#	    	undef _ANSI
#	    	define _ANSI	1
#	    endif
#	endif
#	if _ANSI
#	    define	_PROTOTYPE(function, params)	function params
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST		const
#	    define	_VOLATILE	volatile
#	    define	_SIZET		size_t
#	else
#	    define	_PROTOTYPE(function, params)	function()
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST
#	    define	_VOLATILE
#	    define	_SIZET		int
#	endif /* _ANSI */
#    endif /* _MINIX */
#endif	/* _PROTOTYPE */

_PROTOTYPE( int accept, (int s, char *peername, int *peernamelen)	);
_PROTOTYPE( int bind, (int s, char *name, int namelen)			);
_PROTOTYPE( int connect, (int s, char *peername, int peernamelen)	);
_PROTOTYPE( int getpeername, (int s, char *peername, int *peernamelen)	);
_PROTOTYPE( int getsockname, (int s, char *name, int *namelen)		);
_PROTOTYPE( int listen, (int s, int backlog)				);
_PROTOTYPE( int socket, (int af, int type, int protocol)		);
_PROTOTYPE( int recv, (int s, char *buf, int len, int flags)		);
_PROTOTYPE( int send, (int s, char *buf, int len, int flags)		);
_PROTOTYPE( int recvfrom, (int s, char *buf, int len, int flags, 	\
			   char *from, int *fromlen)			);
_PROTOTYPE( int sendto, (int s, char *buf, int len, int flags,		\
			 char *to, int tolen)				);
_PROTOTYPE( u_long gethostid, (void)					);
_PROTOTYPE( int gethostname, (char *name, int len)			);
_PROTOTYPE( int getdomainname, (char *name, int len)			);
_PROTOTYPE( int sethostid, (u_long id)					);
_PROTOTYPE( int gethostname, (char *name, int len)			);
_PROTOTYPE( int getdomainname, (char *name, int len)			);

#endif	/* _INET_SOCKET_H */
