/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Definitions for the INET name serving protocols.
 *
 * WARNING:	The code in 'gethostent(3N)' uses bit fields, which
 *		manu UNIX-based system compilers do not like...
 *
 * Version:	@(#)arpa/nameser.h	1.00		07/02/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#ifndef _ARPA_NAMESER_H
#define _ARPA_NAMESER_H

#include <arpa/internet.h>


/* Define constants based on RFC 883.  */
#define PACKETSZ	512		/* max packet size		*/
#define MAXDNAME	256		/* max domain name		*/
#define MAXCDNAME	255		/* max compressed domain name	*/
#define MAXLABEL	63		/* max length of domain label	*/
#define QFIXEDSZ	4		/* #bytes of fixed size data in	*/
					/* 		query structure	*/
#define RRFIXEDSZ	10		/* #bytes of fixed size data in	*/
					/*		resource record	*/
#define NAMESERVER_PORT	53		/* Internet nameserver port#	*/

/* Currently defined opcodes. */
#define QUERY		0x0		/* standard query		*/
#define IQUERY		0x1		/* inverse query		*/
#define STATUS		0x2		/* nameserver status query	*/
#define NAMSERXXX	0x3		/* 0x3 reserved			*/
/* Non-standard opcodes. */
#define UPDATEA		0x9		/* add resource record		*/
#define UPDATED		0xa		/* delete a specific rsc record	*/
#define UPDATEDA	0xb		/* delete all nemed rsc record	*/
#define UPDATEM		0xc		/* modify a specific rsc record	*/
#define UPDATEMA	0xd		/* modify all named rsc record	*/

#define ZONEINIT	0xe		/* initial zone transfer	*/
#define ZONEREF		0xf		/* incremental zone referesh	*/

/* Currently defined response codes. */
#define NOERROR		0		/* no error			*/
#define FORMERR		1		/* format error			*/
#define SERVFAIL	2		/* server failure		*/
#define NXDOMAIN	3		/* non existent domain		*/
#define NOTIMP		4		/* not implemented		*/
#define REFUSED		5		/* query refused		*/
/* Non-standard response codes. */
#define NOCHANGE	0xf		/* update failed to change db	*/

/* Type values for resources and queries. */
#define T_A		1		/* host address			*/
#define T_NS		2		/* authoritative server		*/
#define T_MD		3		/* mail destination		*/
#define T_MF		4		/* mail forwarder		*/
#define T_CNAME		5		/* connonical name		*/
#define T_SOA		6		/* start of authority zone	*/
#define T_MB		7		/* mailbox domain name		*/
#define T_MG		8		/* mail group member		*/
#define T_MR		9		/* mail rename name		*/
#define T_NULL		10		/* null resource record		*/
#define T_WKS		11		/* well known service		*/
#define T_PTR		12		/* domain name pointer		*/
#define T_HINFO		13		/* host information		*/
#define T_MINFO		14		/* mailbox information		*/
#define T_MX		15		/* mail routing information	*/
/* Non-standard type values. */
#define T_UINFO		100		/* user (finger) information	*/
#define T_UID		101		/* user ID			*/
#define T_GID		102		/* group ID			*/
#define T_UNSPEC	103		/* Unspecified fmt (bin. data)	*/
/* Query type values which do not appear in resource records. */
#define T_AXFR		252		/* transfer zone of authority	*/
#define T_MAILB		253		/* transfer mailbox records	*/
#define T_MAILA		254		/* transfer mail agent records	*/
#define T_ANY		255		/* wildcard match		*/

/* Values for class field. */
#define C_IN		1		/* the arpa internet		*/
#define C_CHAOS		3		/* for chaos net at MIT		*/
/* Query class values which do not appear in resource records. */
#define C_ANY		255		/* wildcard match		*/

/* Status return codes for T_UNSPEC conversion routines. */
#define CONV_SUCCESS	0
#define CONV_OVERFLOW	-1
#define CONV_BADFMT	-2
#define CONV_BADCKSUM	-3
#define CONV_BADBUFLEN	-4

/*
 * Structure for query header, the order of the fields is machine and
 * compiler dependent, in our case, the bits within a byte are assignd 
 * least significant first, while the order of transmition is most 
 * significant first.  This requires a somewhat confusing rearrangement.
 */
typedef struct {
  u_short	id;		/* query identification number		*/
  u_char	third;		/* fields in third byte			*/
  u_char	fourth;		/* fields in fourth byte		*/
  u_short	qdcount;	/* number of question entries		*/
  u_short	ancount;	/* number of answer entries		*/
  u_short	nscount;	/* number of authority entries		*/
  u_short	arcount;	/* number of resource entries		*/
} HEADER;
#define THIRD_OPCODE	((u_char)(0x08 | 0x04 | 0x02 | 0x01))
#define THIRD_RD	((u_char)0x10)
#define THIRD_TC	((u_char)0x20)
#define THIRD_AA	((u_char)0x40)
#define THIRD_QR	((u_char)0x00)
#define FOURTH_RCODE	((u_char)(0x08 | 0x04 | 0x02 | 0x01))
#define FOURTH_UNUSED	((u_char)(0x20 | 0x10))
#define FOURTH_PR	((u_char)0x40)
#define FOURTH_RA	((u_char)0x80)


/* Defines for handling compressed domain names. */
#define INDIR_MASK	0xc0


/* Structure for passing resource records around. */
struct rrec {
  u_short	r_zone;			/* zone number			*/
  u_short	r_class;		/* class number			*/
  u_short	r_type;			/* type number			*/
  u_long	r_ttl;			/* time to live			*/
  u_short	r_size;			/* size of data area		*/
  char		*r_data;		/* pointer to data		*/
};

#endif /* _ARPA_NAMESER_H */
