/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file contains the IP protocol definitions.
 *
 * Version:	@(#)arpa/ip.h		1.03	07/02/92
 *
 * Authors:	Original by Phil Karn KA9Q.
 *		Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#ifndef _ARPA_IP_H
#define _ARPA_IP_H

#define	IP_VERSION	4		/* version# of our IP software	*/

#define	IPF_F_OFFSET	0x1fff		/* Offset field			*/
#define	IPF_DF		0x4000		/* Don't fragment flag		*/
#define	IPF_MF		0x2000		/* More Fragments flag		*/

typedef struct ip_header {
  u_char	v_ihl;			/* Version + IP header length	*/
  u_char	tos;			/* Type of service		*/
  u_short	length;			/* Total length			*/
  u_short	id;			/* Identification		*/
  u_short	fl_offs;		/* Flags + fragment offset	*/
  u_char	ttl;			/* Time to live			*/
  u_char	protocol;		/* Protocol			*/
  u_short	checksum;		/* Header checksum		*/
  u_long	source;			/* Source address		*/
  u_long	dest;			/* Destination address		*/
} IP;

/* Fields in option type byte */
#define	IP_OF_COPIED	0x80		/* Copied-on-fragmentation flag	*/
#define	IP_OF_CLASS	0x60		/* Option class			*/
#define	IP_OF_NUMBER	0x1f		/* Option number		*/

/* IP option numbers */
#define	IPO_EOL		0		/* End of options list		*/
#define	IPO_NOOP	1		/* No Operation			*/
#define	IPO_SECURITY	2		/* Security parameters		*/
#define	IPO_LSROUTE	3		/* Loose Source Routing		*/
#define	IPO_TIMESTAMP	4		/* Internet Timestamp		*/
#define	IPO_RROUTE	7		/* Record Route			*/
#define	IPO_STREAMID	8		/* Stream ID			*/
#define	IPO_SSROUTE	9		/* Strict Source Routing	*/

/* Timestamp option flags */
#define	IP_TS_ONLY	0		/* Time stamps only		*/
#define	IP_TS_ADDRESS	1		/* Addresses + Time stamps	*/
#define	IP_TS_PRESPEC	3		/* Prespecified addresses only	*/

#endif	/* _ARPA_IP_H */
